/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.wagon;

import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.generators.FileBodyGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.resource.Resource;
import org.sonatype.maven.wagon.AhcWagon;

class ProgressingFileBodyGenerator
extends FileBodyGenerator {
    private final File file;
    private final AhcWagon wagon;
    private final TransferEvent event;
    private byte[] bytes = new byte[16384];

    public ProgressingFileBodyGenerator(File file, Resource resource, AhcWagon wagon) {
        super(file);
        this.file = file;
        this.wagon = wagon;
        this.event = new TransferEvent((Wagon)wagon, resource, 3, 6);
        this.event.setTimestamp(System.currentTimeMillis());
    }

    void fireTransferProgressed(ByteBuffer buffer) {
        int count = buffer.remaining();
        if (count > this.bytes.length) {
            this.bytes = new byte[count];
        }
        buffer.get(this.bytes, 0, count);
        this.wagon.fireTransferProgressed(this.event, count, this.bytes);
    }

    public RandomAccessBody createBody() throws IOException {
        this.wagon.firePutStarted(this.file, this.event.getResource());
        return new ProgressingBody(super.createBody());
    }

    final class ProgressingBody
    implements RandomAccessBody {
        final RandomAccessBody delegate;
        private ProgressingWritableByteChannel channel;

        public ProgressingBody(RandomAccessBody delegate) {
            this.delegate = delegate;
        }

        public long getContentLength() {
            return this.delegate.getContentLength();
        }

        public long read(ByteBuffer buffer) throws IOException {
            ByteBuffer eventBuffer = buffer.slice();
            long read = this.delegate.read(buffer);
            if (read > 0L) {
                eventBuffer.limit((int)read);
                ProgressingFileBodyGenerator.this.fireTransferProgressed(eventBuffer);
            }
            return read;
        }

        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            ProgressingWritableByteChannel dst = this.channel;
            if (dst == null || dst.delegate != target) {
                this.channel = dst = new ProgressingWritableByteChannel(target);
            }
            return this.delegate.transferTo(position, Math.min(count, 16384L), (WritableByteChannel)dst);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    final class ProgressingWritableByteChannel
    implements WritableByteChannel {
        final WritableByteChannel delegate;

        public ProgressingWritableByteChannel(WritableByteChannel delegate) {
            this.delegate = delegate;
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public int write(ByteBuffer src) throws IOException {
            ByteBuffer eventBuffer = src.slice();
            int written = this.delegate.write(src);
            if (written > 0) {
                eventBuffer.limit(written);
                ProgressingFileBodyGenerator.this.fireTransferProgressed(eventBuffer);
            }
            return written;
        }
    }
}

