/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.wagon;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.maven.wagon.GetExchange;
import org.sonatype.maven.wagon.GetExchangeHandler;
import org.sonatype.maven.wagon.ProgressingFileBodyGenerator;
import org.sonatype.maven.wagon.PutOutputStream;
import org.sonatype.maven.wagon.UrlUtils;

public class AhcWagon
extends StreamWagon {
    private boolean useCache;
    private int maxRedirections = 10;
    private Properties httpHeaders;
    private String credentialEncoding = "ISO-8859-1";
    private AsyncHttpClient httpClient;

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        ProxyInfo proxyInfo;
        String protocol = UrlUtils.getProtocol(this.getRepository().getUrl());
        protocol = UrlUtils.normalizeProtocol(protocol);
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        Realm.RealmBuilder realmBuilder = null;
        if (this.authenticationInfo != null) {
            String username = this.authenticationInfo.getUserName();
            String password = this.authenticationInfo.getPassword();
            realmBuilder = new Realm.RealmBuilder().setPrincipal(username).setPassword(password).setUsePreemptiveAuth(false).setEnconding(this.credentialEncoding);
            builder.setRealm(realmBuilder.build());
        }
        if ((proxyInfo = this.getProxyInfo(protocol, this.getRepository().getHost())) == null && "https".equalsIgnoreCase(protocol)) {
            proxyInfo = this.getProxyInfo("http", this.getRepository().getHost());
        }
        if (proxyInfo != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            int proxyPort = proxyInfo.getPort();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (StringUtils.isNotEmpty((String)proxyNtlmHost)) {
                proxyHost = proxyNtlmDomain;
            }
            if (proxyHost != null) {
                ProxyServer proxyServer = new ProxyServer(proxyHost, proxyPort);
                if (proxyUsername != null && proxyPassword != null) {
                    proxyServer = new ProxyServer(proxyHost, proxyPort, proxyUsername, proxyPassword);
                    proxyServer.setEncoding(this.credentialEncoding);
                } else {
                    proxyServer = new ProxyServer(proxyHost, proxyPort);
                }
                if (StringUtils.isNotEmpty((String)proxyNtlmDomain)) {
                    proxyServer.setNtlmDomain(proxyNtlmDomain);
                }
                builder.setProxyServer(proxyServer);
            }
        }
        builder.setConnectionTimeoutInMs(this.getTimeout());
        builder.setRequestTimeoutInMs(this.getTimeout());
        builder.setFollowRedirects(this.maxRedirections > 0);
        builder.setMaximumNumberOfRedirects(this.maxRedirections);
        builder.setUserAgent("Apache-Maven");
        builder.setCompressionEnabled(true);
        if (this.httpHeaders != null && this.httpHeaders.getProperty("User-Agent") != null) {
            builder.setUserAgent(this.httpHeaders.getProperty("User-Agent"));
        }
        AsyncHttpClientConfig config = builder.build();
        this.httpClient = new AsyncHttpClient((AsyncHttpProvider)new NettyAsyncHttpProvider(config), config);
    }

    public void closeConnection() throws ConnectionException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
    }

    public void setHttpHeaders(Properties properties) {
        if (properties != null) {
            this.httpHeaders = new Properties();
            this.httpHeaders.putAll((Map<?, ?>)properties);
        } else {
            this.httpHeaders = null;
        }
    }

    private void addHeaders(AsyncHttpClient.BoundRequestBuilder builder) {
        builder.addHeader("Accept-Encoding", "gzip");
        if (!this.useCache) {
            builder.addHeader("Pragma", "no-cache");
            builder.addHeader("Cache-Control", "no-cache, no-store");
        }
        if (this.httpHeaders != null) {
            for (Object key : this.httpHeaders.keySet()) {
                builder.addHeader(key.toString(), this.httpHeaders.getProperty(key.toString()));
            }
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            String url = UrlUtils.buildUrl(this.getRepository().getUrl(), resourceName);
            AsyncHttpClient.BoundRequestBuilder builder = this.httpClient.prepareHead(url);
            this.addHeaders(builder);
            Response response = (Response)builder.execute().get();
            int statusCode = response.getStatusCode();
            switch (statusCode) {
                case 200: {
                    return true;
                }
                case 404: {
                    return false;
                }
                case 401: 
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url + " (" + statusCode + ")");
                }
            }
            throw new TransferFailedException("Failed to check for existence of resource " + url + " (" + statusCode + ")");
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException("Transfer was aborted by client: " + e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TransferFailedException("Transfer was aborted by client: " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        try {
            String url = UrlUtils.buildUrl(this.getRepository().getUrl(), resource.getName());
            AsyncHttpClient.BoundRequestBuilder builder = this.httpClient.prepareGet(url);
            builder.setFollowRedirects(true);
            this.addHeaders(builder);
            GetExchange exchange = new GetExchange(this.httpClient);
            builder.execute((AsyncHandler)new GetExchangeHandler(exchange));
            exchange.await();
            if (exchange.getError() != null) {
                throw (IOException)new IOException(exchange.getError().getMessage()).initCause(exchange.getError());
            }
            int statusCode = exchange.getStatusCode();
            switch (statusCode) {
                case 200: 
                case 304: {
                    break;
                }
                case 401: 
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url + " (" + statusCode + ")");
                }
                case 404: {
                    throw new ResourceDoesNotExistException("Unable to locate resource in repository");
                }
                default: {
                    throw new TransferFailedException("Error transferring file, server returned status code " + statusCode);
                }
            }
            inputData.setInputStream(exchange.getInputStream());
            resource.setLastModified(exchange.getLastModified());
            resource.setContentLength(exchange.getContentLength());
        }
        catch (URISyntaxException e) {
            throw new ResourceDoesNotExistException("Invalid repository URL", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException("Transfer was aborted by client: " + e.getMessage(), (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Resource resource = outputData.getResource();
        try {
            String url = UrlUtils.buildUrl(this.getRepository().getUrl(), resource.getName());
            AsyncHttpClient.BoundRequestBuilder builder = this.httpClient.preparePut(url);
            this.addHeaders(builder);
            PutOutputStream pos = new PutOutputStream(builder, url, resource.getContentLength());
            outputData.setOutputStream((OutputStream)pos);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException("Invalid repository URL", (Throwable)e);
        }
    }

    protected void finishPutTransfer(Resource resource, InputStream input, OutputStream output) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        PutOutputStream pos = (PutOutputStream)output;
        try {
            Response response = pos.send();
            this.handleStatusCode(response.getStatusCode(), pos.getUrl());
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException("Error transferring file", (Throwable)e);
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        try {
            String url = UrlUtils.buildUrl(this.getRepository().getUrl(), resource.getName());
            AsyncHttpClient.BoundRequestBuilder builder = this.httpClient.preparePut(url);
            this.addHeaders(builder);
            builder.setBody((BodyGenerator)new ProgressingFileBodyGenerator(source, resource, this));
            Response response = (Response)builder.execute().get();
            this.handleStatusCode(response.getStatusCode(), url);
            this.firePutCompleted(resource, source);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException("Invalid repository URL", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException("Transfer was aborted by client: " + e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TransferFailedException("Transfer was aborted by client: " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void handleStatusCode(int statusCode, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        switch (statusCode) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                break;
            }
            case 401: 
            case 403: {
                throw new AuthorizationException("Access denied to: " + url + " (" + statusCode + ")");
            }
            case 404: {
                throw new ResourceDoesNotExistException("File " + url + " does not exist");
            }
            default: {
                throw new TransferFailedException("Failed to transfer file " + url + ". Return code is: " + statusCode);
            }
        }
    }

    void firePutStarted(File source, Resource resource) {
        this.firePutStarted(resource, source);
    }

    void fireTransferProgressed(TransferEvent event, int count, byte[] buffer) {
        this.fireTransferProgress(event, buffer, count);
    }
}

