/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.subwords;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.internal.completion.rcp.subwords.LCSS;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsProposalContext;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsUtils;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.ProposalFactory;

public class SubwordsCompletionRequestor
extends CompletionRequestor {
    private final List<IJavaCompletionProposal> proposals = Lists.newLinkedList();
    private final Set<String> duplicates = Sets.newHashSet();
    private final JavaContentAssistInvocationContext ctx;
    private final CompletionProposalCollector collector;
    private final String prefix;

    public SubwordsCompletionRequestor(String prefix, JavaContentAssistInvocationContext ctx) {
        super(false);
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)ctx);
        this.prefix = prefix;
        this.ctx = ctx;
        this.collector = this.shouldFillArgumentNames() ? new FillArgumentNamesCompletionProposalCollector(ctx) : new CompletionProposalCollector(ctx.getCompilationUnit(), false);
        this.collector.acceptContext(ctx.getCoreContext());
        this.collector.setInvocationContext(ctx);
        this.collector.setIgnored(13, false);
        this.collector.setIgnored(1, false);
        this.collector.setIgnored(27, false);
        this.collector.setIgnored(2, false);
        this.collector.setIgnored(25, false);
        this.collector.setIgnored(3, false);
        this.collector.setIgnored(4, false);
        this.collector.setIgnored(5, false);
        this.collector.setIgnored(7, false);
        this.collector.setIgnored(12, false);
        this.collector.setIgnored(6, false);
        this.collector.setIgnored(26, false);
        this.collector.setIgnored(24, false);
        this.collector.setIgnored(8, false);
        this.collector.setIgnored(11, false);
        this.collector.setIgnored(10, false);
        this.collector.setIgnored(9, false);
        this.collector.setAllowsRequiredProposals(2, 9, true);
        this.collector.setAllowsRequiredProposals(2, 23, true);
        this.collector.setAllowsRequiredProposals(2, 21, true);
        this.collector.setAllowsRequiredProposals(6, 9, true);
        this.collector.setAllowsRequiredProposals(6, 23, true);
        this.collector.setAllowsRequiredProposals(6, 22, true);
        this.collector.setAllowsRequiredProposals(26, 9, true);
        this.collector.setAllowsRequiredProposals(27, 9, true);
        this.collector.setAllowsRequiredProposals(1, 9, true);
        this.collector.setAllowsRequiredProposals(9, 9, true);
        this.collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        this.collector.setRequireExtendedContext(true);
    }

    @VisibleForTesting
    protected boolean shouldFillArgumentNames() {
        try {
            return PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean isAllowingRequiredProposals(int proposalKind, int requiredProposalKind) {
        boolean isAllowed = this.collector.isAllowingRequiredProposals(proposalKind, requiredProposalKind);
        return isAllowed;
    }

    public boolean isIgnored(int completionProposalKind) {
        boolean ignored = this.collector.isIgnored(completionProposalKind);
        return ignored;
    }

    public void acceptContext(CompletionContext context) {
        super.acceptContext(context);
        this.collector.acceptContext(context);
    }

    public boolean isExtendedContextRequired() {
        return this.collector.isExtendedContextRequired();
    }

    private String[] getFavoriteStaticMembers() {
        String serializedFavorites = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (serializedFavorites != null && serializedFavorites.length() > 0) {
            return serializedFavorites.split(";");
        }
        return new String[0];
    }

    public void accept(CompletionProposal proposal) {
        if (this.isDuplicate(proposal)) {
            return;
        }
        String subwordsMatchingRegion = SubwordsUtils.getTokensBetweenLastWhitespaceAndFirstOpeningBracket(proposal);
        if (!subwordsMatchingRegion.isEmpty() && !LCSS.containsSubsequence(subwordsMatchingRegion, this.prefix)) {
            return;
        }
        IJavaCompletionProposal[] iJavaCompletionProposalArray = this.tryCreateJdtProposal(proposal);
        int n = iJavaCompletionProposalArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaCompletionProposal p = iJavaCompletionProposalArray[n2];
            SubwordsProposalContext subwordsContext = new SubwordsProposalContext(this.prefix, proposal, p, this.ctx);
            this.createSubwordsProposal(subwordsContext);
            ++n2;
        }
    }

    private boolean isDuplicate(CompletionProposal proposal) {
        String key;
        char[] s;
        StringBuilder sb = new StringBuilder();
        char[] c = proposal.getCompletion();
        sb.append(c);
        char[] d = proposal.getDeclarationSignature();
        if (d != null) {
            sb.append(d);
        }
        if ((s = proposal.getSignature()) != null) {
            sb.append(s);
        }
        return !this.duplicates.add(key = sb.toString());
    }

    private IJavaCompletionProposal[] tryCreateJdtProposal(CompletionProposal proposal) {
        int oldLength = this.collector.getJavaCompletionProposals().length;
        this.collector.accept(proposal);
        Object[] jdtProposals = this.collector.getJavaCompletionProposals();
        IJavaCompletionProposal[] newProposals = (IJavaCompletionProposal[])ArrayUtils.subarray((Object[])jdtProposals, (int)oldLength, (int)jdtProposals.length);
        return newProposals;
    }

    private void createSubwordsProposal(SubwordsProposalContext subwordsContext) {
        IJavaCompletionProposal subWordProposal = ProposalFactory.createFromJDTProposal(subwordsContext);
        if (subWordProposal != null) {
            this.proposals.add(subWordProposal);
        }
    }

    public List<IJavaCompletionProposal> getProposals() {
        return this.proposals;
    }

    public void setReplacementLength(int y) {
        this.collector.setReplacementLength(y);
    }
}

