/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.engine;

import com.google.common.base.Optional;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.recommenders.internal.utils.codestructs.DefinitionSite;
import org.eclipse.recommenders.internal.utils.codestructs.ObjectUsage;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.rcp.ast.BindingUtils;

public class AstBasedObjectUsageResolver
extends ASTVisitor {
    private String varname;
    private ObjectUsage res;

    public boolean visit(MethodInvocation node) {
        if (this.receiverExpressionMatchesVarname(node.getExpression()) || this.isThis() && this.isReceiverThis(node)) {
            IMethodBinding b = node.resolveMethodBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        return false;
    }

    private boolean receiverExpressionMatchesVarname(Expression exp) {
        if (exp == null) {
            return false;
        }
        switch (exp.getNodeType()) {
            case 40: 
            case 42: {
                Name name = (Name)Checks.cast((Object)exp);
                return this.matchesVarName(name);
            }
            case 52: {
                return this.isThis();
            }
        }
        return false;
    }

    private boolean matchesVarName(Name node) {
        if (node == null) {
            return false;
        }
        String name = node.getFullyQualifiedName();
        return this.varname.equals(name);
    }

    private boolean isThis() {
        return "this".equals(this.varname);
    }

    private boolean isReceiverThis(MethodInvocation mi) {
        Expression expression = mi.getExpression();
        if (expression == null && !this.isStatic(mi)) {
            return true;
        }
        return expression instanceof ThisExpression;
    }

    private boolean isStatic(MethodInvocation call) {
        IMethodBinding binding = call.resolveMethodBinding();
        if (binding != null) {
            return JdtFlags.isStatic((IMethodBinding)binding);
        }
        return false;
    }

    private void registerMethodCallOnReceiver(IMethodBinding b) {
        Optional opt = BindingUtils.toMethodName((IMethodBinding)b);
        if (opt.isPresent()) {
            this.res.calls.add((IMethodName)opt.get());
        }
    }

    public ObjectUsage findObjectUsage(String varname, MethodDeclaration method) {
        Checks.ensureIsNotNull((Object)varname);
        Checks.ensureIsNotNull((Object)method);
        this.setVarname(varname);
        this.initializeResult();
        if ("".equals(varname) || "this".equals(varname) || "super".equals(varname)) {
            this.res.kind = DefinitionSite.Kind.THIS;
        }
        method.accept((ASTVisitor)this);
        if (this.res.kind == null) {
            this.res.kind = DefinitionSite.Kind.FIELD;
        }
        return this.res;
    }

    private void setVarname(String varname) {
        this.varname = varname;
    }

    private void initializeResult() {
        this.res = new ObjectUsage();
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        if (lhs == null) {
            return true;
        }
        switch (lhs.getNodeType()) {
            case 40: 
            case 42: {
                Name n = (Name)Checks.cast((Object)lhs);
                if (this.matchesVarName(n)) break;
                return true;
            }
            default: {
                return true;
            }
        }
        Expression rhs = node.getRightHandSide();
        this.evaluateRightHandSideExpression(rhs);
        return true;
    }

    private void evaluateRightHandSideExpression(Expression expression) {
        switch (expression.getNodeType()) {
            case 11: {
                CastExpression ce = (CastExpression)Checks.cast((Object)expression);
                this.evaluateRightHandSideExpression(ce.getExpression());
                break;
            }
            case 32: {
                MethodInvocation mi = (MethodInvocation)Checks.cast((Object)expression);
                this.res.definition = (IMethodName)BindingUtils.toMethodName((IMethodBinding)mi.resolveMethodBinding()).orNull();
                this.res.kind = DefinitionSite.Kind.METHOD_RETURN;
                break;
            }
            case 48: {
                SuperMethodInvocation smi = (SuperMethodInvocation)Checks.cast((Object)expression);
                this.res.definition = (IMethodName)BindingUtils.toMethodName((IMethodBinding)smi.resolveMethodBinding()).orNull();
                this.res.kind = DefinitionSite.Kind.METHOD_RETURN;
                break;
            }
            case 14: {
                ClassInstanceCreation cic = (ClassInstanceCreation)Checks.cast((Object)expression);
                this.res.definition = (IMethodName)BindingUtils.toMethodName((IMethodBinding)cic.resolveConstructorBinding()).orNull();
                this.res.kind = DefinitionSite.Kind.NEW;
                break;
            }
            case 42: {
                SimpleName cfr_ignored_0 = (SimpleName)Checks.cast((Object)expression);
                if (this.res.kind != null) break;
                this.res.kind = DefinitionSite.Kind.UNKNOWN;
                break;
            }
        }
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.isThis()) {
            IMethodBinding b = node.resolveConstructorBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (this.matchesVarName((Name)node.getName())) {
            IVariableBinding b = node.resolveBinding();
            this.evaluateVariableBinding(b);
        }
        return true;
    }

    private void evaluateVariableBinding(IVariableBinding b) {
        if (b == null || !this.matchesVarname(b) || this.isVartypeKnown()) {
            return;
        }
        this.res.type = (ITypeName)BindingUtils.toTypeName((ITypeBinding)b.getType()).orNull();
        if (this.res.kind != null) {
            return;
        }
        if (b.isParameter()) {
            this.res.kind = DefinitionSite.Kind.PARAMETER;
            IMethodName method = (IMethodName)BindingUtils.toMethodName((IMethodBinding)b.getDeclaringMethod()).orNull();
            if (method != null) {
                this.res.definition = method;
            }
        } else {
            this.res.kind = b.isField() ? DefinitionSite.Kind.FIELD : DefinitionSite.Kind.UNKNOWN;
        }
    }

    private boolean matchesVarname(IVariableBinding b) {
        return this.varname.equals(b.getName());
    }

    private boolean isVartypeKnown() {
        boolean isVarTypeKnown = this.res.type != null;
        return isVarTypeKnown;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.isThis()) {
            IMethodBinding b = node.resolveConstructorBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.isThis()) {
            IMethodBinding b = node.resolveMethodBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        for (VariableDeclarationFragment f : node.fragments()) {
            this.evaluateVariableDeclarationFragment(f);
        }
        return true;
    }

    private void evaluateVariableDeclarationFragment(VariableDeclarationFragment f) {
        Expression expression;
        SimpleName name = f.getName();
        if (this.matchesVarName((Name)name) && (expression = f.getInitializer()) != null) {
            this.evaluateRightHandSideExpression(expression);
        }
    }

    public boolean visit(VariableDeclarationExpression node) {
        for (VariableDeclarationFragment f : node.fragments()) {
            this.evaluateVariableDeclarationFragment(f);
        }
        return true;
    }

    public boolean visit(QualifiedName node) {
        this.evaluateName((Name)node);
        return true;
    }

    private void evaluateName(Name node) {
        if (this.matchesVarName(node)) {
            this.evaluateVariableBinding(BindingUtils.getVariableBinding((Name)node));
        }
    }

    public boolean visit(SimpleName node) {
        this.evaluateName((Name)node);
        return true;
    }

    private Optional<IVariableBinding> findReceiver(MethodInvocation call) {
        Expression exp = call.getExpression();
        if (exp == null && !this.isStatic(call)) {
            return Optional.of((Object)new ThisVariableBinding());
        }
        switch (exp.getNodeType()) {
            case 40: 
            case 42: {
                Name name = (Name)Checks.cast((Object)exp);
                IVariableBinding b = BindingUtils.getVariableBinding((Name)name);
                return Optional.fromNullable((Object)b);
            }
            case 52: {
                return Optional.of((Object)new ThisVariableBinding());
            }
        }
        return Optional.absent();
    }

    private class ThisVariableBinding
    implements IVariableBinding {
        private ThisVariableBinding() {
        }

        public IAnnotationBinding[] getAnnotations() {
            return null;
        }

        public int getKind() {
            return 0;
        }

        public int getModifiers() {
            return 0;
        }

        public boolean isDeprecated() {
            return false;
        }

        public boolean isRecovered() {
            return false;
        }

        public boolean isSynthetic() {
            return false;
        }

        public IJavaElement getJavaElement() {
            return null;
        }

        public String getKey() {
            return null;
        }

        public boolean isEqualTo(IBinding binding) {
            return false;
        }

        public boolean isField() {
            return false;
        }

        public boolean isEnumConstant() {
            return false;
        }

        public boolean isParameter() {
            return true;
        }

        public String getName() {
            return "this";
        }

        public ITypeBinding getDeclaringClass() {
            return null;
        }

        public ITypeBinding getType() {
            return null;
        }

        public int getVariableId() {
            return 0;
        }

        public Object getConstantValue() {
            return null;
        }

        public IMethodBinding getDeclaringMethod() {
            return null;
        }

        public IVariableBinding getVariableDeclaration() {
            return null;
        }
    }
}

