/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp.ast;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class BindingUtils {
    public static Optional<ITypeName> toTypeName(ITypeBinding b) {
        String binaryName;
        if (b == null) {
            return Optional.absent();
        }
        StringBuilder sb = new StringBuilder();
        if ((b = b.getErasure()).isArray()) {
            int i = b.getDimensions();
            while (i-- > 0) {
                sb.append('[');
            }
            if ((b = b.getElementType()) == null) {
                return Optional.absent();
            }
        }
        if ((binaryName = b.getBinaryName()) == null) {
            return Optional.absent();
        }
        if (b.isPrimitive()) {
            sb.append(binaryName);
        } else {
            sb.append('L').append(binaryName.replace('.', '/'));
        }
        try {
            VmTypeName res = VmTypeName.get((String)sb.toString());
            return Optional.of((Object)res);
        }
        catch (Exception e) {
            RecommendersUtilsPlugin.logError(e, "failed to create type name from %s", b);
            return Optional.absent();
        }
    }

    public static Optional<ITypeName> toTypeName(Type type) {
        if (type == null) {
            return Optional.absent();
        }
        ITypeBinding b = type.resolveBinding();
        if (b == null) {
            return Optional.absent();
        }
        return BindingUtils.toTypeName(b);
    }

    public static List<ITypeName> toTypeNames(ITypeBinding[] interfaces) {
        LinkedList res = Lists.newLinkedList();
        ITypeBinding[] iTypeBindingArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding b = iTypeBindingArray[n2];
            Optional<ITypeName> opt = BindingUtils.toTypeName(b);
            if (opt.isPresent()) {
                res.add((ITypeName)opt.get());
            }
            ++n2;
        }
        return res;
    }

    private static boolean needsColon(ITypeBinding p) {
        if (p.isArray()) {
            return !p.getElementType().isPrimitive();
        }
        return !p.isPrimitive();
    }

    public static Optional<IMethodName> toMethodName(IMethodBinding b) {
        VmMethodName ref;
        if (b == null) {
            return Optional.absent();
        }
        IMethodBinding decl = b.getMethodDeclaration();
        if (decl != null) {
            b = decl;
        }
        StringBuilder sb = new StringBuilder();
        ITypeName declaringType = (ITypeName)BindingUtils.toTypeName(b.getDeclaringClass()).orNull();
        if (declaringType == null) {
            return Optional.absent();
        }
        String methodName = b.isConstructor() ? "<init>" : b.getName();
        sb.append(declaringType).append(".").append(methodName).append("(");
        ITypeBinding[] iTypeBindingArray = b.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding param = iTypeBindingArray[n2];
            ITypeName paramType = (ITypeName)BindingUtils.toTypeName(param).orNull();
            if (paramType == null) {
                return Optional.absent();
            }
            sb.append(paramType);
            if (BindingUtils.needsColon(param)) {
                sb.append(';');
            }
            ++n2;
        }
        ITypeBinding returnType = b.getReturnType();
        ITypeName obj = (ITypeName)BindingUtils.toTypeName(returnType).orNull();
        if (obj == null) {
            return Optional.absent();
        }
        sb.append(")").append(obj);
        if (BindingUtils.needsColon(returnType)) {
            sb.append(';');
        }
        try {
            ref = VmMethodName.get((String)sb.toString());
        }
        catch (Exception e1) {
            RecommendersUtilsPlugin.logError(e1, "failed to create IMethodName from binding '%s'", b);
            return Optional.absent();
        }
        return Optional.of((Object)ref);
    }

    public static IVariableBinding getVariableBinding(Name name) {
        IBinding b = name.resolveBinding();
        return (IVariableBinding)(b instanceof IVariableBinding ? b : null);
    }
}

