/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImagePreviewComposite;

public abstract class AbstractImageDialog
extends ResizableDialog {
    private ImageInfo m_imageInfo;
    private String m_input_pageId;
    private Object m_input_pageData;
    private Group m_pageButtonsGroup;
    private Group m_pagesGroup;
    private ImagePreviewComposite m_previewComposite;
    private final Map<String, AbstractImagePage> m_idToPage = Maps.newTreeMap();
    private final Map<String, Button> m_idToButton = Maps.newTreeMap();

    protected AbstractImageDialog(Shell parentShell, AbstractUIPlugin plugin) {
        super(parentShell, plugin);
    }

    public final void setInput(String pageId, Object pageData) {
        AbstractImagePage page;
        this.m_input_pageId = pageId;
        this.m_input_pageData = pageData;
        if (this.m_input_pageId != null && (page = this.m_idToPage.get(this.m_input_pageId)) != null) {
            page.init(this.m_input_pageData);
        }
    }

    public final ImageInfo getImageInfo() {
        return this.m_imageInfo;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridDataFactory.create((Control)area).grab().fill();
        GridLayoutFactory.create(area).columns(2).equalColumns();
        this.m_pageButtonsGroup = new Group(area, 0);
        GridDataFactory.create((Control)this.m_pageButtonsGroup).spanH(2).grabH().fill();
        GridLayoutFactory.create((Composite)this.m_pageButtonsGroup);
        this.m_pageButtonsGroup.setText(Messages.AbstractImageDialog_modeLabel);
        this.m_pagesGroup = new Group(area, 0);
        GridDataFactory.create((Control)this.m_pagesGroup).grab().fill();
        this.m_pagesGroup.setLayout((Layout)new StackLayout());
        this.m_pagesGroup.setText(Messages.AbstractImageDialog_parametersGroup);
        Group previewGroup = new Group(area, 0);
        GridDataFactory.create((Control)previewGroup).hint(300, 350).fill();
        previewGroup.setLayout((Layout)new FillLayout());
        previewGroup.setText(Messages.AbstractImageDialog_previewGroup);
        this.m_previewComposite = new ImagePreviewComposite((Composite)previewGroup, 0);
        this.addPages((Composite)this.m_pagesGroup);
        return area;
    }

    protected Control createContents(Composite parent) {
        AbstractImagePage page;
        Control contents = super.createContents(parent);
        if (this.m_input_pageId != null && (page = this.m_idToPage.get(this.m_input_pageId)) != null) {
            Button button = this.m_idToButton.get(this.m_input_pageId);
            button.setSelection(true);
            this.setActivePage(page);
            page.setInput(this.m_input_pageData);
        }
        return contents;
    }

    protected final void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AbstractImageDialog_title);
    }

    protected final void addPage(AbstractImagePage page) {
        String id = page.getId();
        String title = page.getTitle();
        this.m_idToPage.put(id, page);
        final Button button = new Button((Composite)this.m_pageButtonsGroup, 16);
        this.m_idToButton.put(id, button);
        button.setText(title);
        button.setData((Object)page);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (button.getSelection()) {
                    AbstractImagePage newPage = (AbstractImagePage)((Object)button.getData());
                    AbstractImageDialog.this.setActivePage(newPage);
                }
            }
        });
    }

    private void setActivePage(AbstractImagePage page) {
        page.activate();
        StackLayout stackLayout = (StackLayout)this.m_pagesGroup.getLayout();
        stackLayout.topControl = page.getPageControl();
        this.m_pagesGroup.layout();
    }

    protected abstract void addPages(Composite var1);

    public final void setResultImageInfo(ImageInfo imageInfo) {
        this.m_imageInfo = imageInfo;
        if (this.m_previewComposite != null) {
            this.m_previewComposite.setImageInfo(this.m_imageInfo);
        }
        this.getButton(0).setEnabled(this.m_imageInfo != null);
    }

    public final void closeOk() {
        if (this.m_imageInfo != null) {
            this.setReturnCode(0);
            this.close();
        }
    }
}

