/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.generic;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProvider;
import org.eclipse.wb.internal.core.editor.palette.model.entry.AttributesProviders;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalStaticFactoriesRootProcessor
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new LocalStaticFactoriesRootProcessor();

    private LocalStaticFactoriesRootProcessor() {
    }

    @Override
    public void process(JavaInfo root, List<JavaInfo> components) throws Exception {
        LocalStaticFactoriesRootProcessor.processRoot(root);
    }

    private static void processRoot(final JavaInfo rootJavaInfo) {
        ExecutionUtils.runIgnore(new RunnableEx(){

            public void run() throws Exception {
                LocalStaticFactoriesRootProcessor.installPaletteBroadcastEx(rootJavaInfo);
            }
        });
    }

    private static void installPaletteBroadcastEx(JavaInfo rootJavaInfo) throws Exception {
        final Map<String, FactoryMethodDescription> descriptionsMap = LocalStaticFactoriesRootProcessor.getLocalFactories(rootJavaInfo);
        if (!descriptionsMap.isEmpty()) {
            rootJavaInfo.addBroadcastListener(new PaletteEventListener(){

                @Override
                public void categories(List<CategoryInfo> categories) throws Exception {
                    CategoryInfo category = LocalStaticFactoriesRootProcessor.createLocalFactoriesCategory(descriptionsMap);
                    categories.add(category);
                }
            });
        }
    }

    private static Map<String, FactoryMethodDescription> getLocalFactories(JavaInfo rootJavaInfo) throws Exception {
        AstEditor editor = rootJavaInfo.getEditor();
        if (!editor.getSource().contains("@wbp.factory")) {
            return (Map)ImmutableMap.of();
        }
        String editorTypeName = editor.getModelUnit().findPrimaryType().getFullyQualifiedName();
        Class<?> possibleFactoryClass = JavaInfoUtils.getClassLoader(rootJavaInfo).loadClass(editorTypeName);
        return FactoryDescriptionHelper.getDescriptionsMap(editor, possibleFactoryClass, true);
    }

    private static CategoryInfo createLocalFactoriesCategory(Map<String, FactoryMethodDescription> descriptionsMap) {
        CategoryInfo category = new CategoryInfo("wbp.Core.localFactories");
        category.setName("Local Factories");
        category.setDescription("Automatically added category with entries for local factory methods.");
        for (FactoryMethodDescription methodDescription : descriptionsMap.values()) {
            String factoryClassName = methodDescription.getDeclaringClass().getName();
            AttributesProvider attributes = AttributesProviders.get((Map)ImmutableMap.of((Object)"signature", (Object)methodDescription.getSignature()));
            StaticFactoryEntryInfo entry = new StaticFactoryEntryInfo(category, factoryClassName, attributes);
            category.addEntry(entry);
        }
        return category;
    }
}

