/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IDescriptionHelper;
import org.eclipse.wb.internal.core.utils.state.ILayoutRequestValidatorHelper;
import org.eclipse.wb.internal.core.utils.state.IOrderProcessor;
import org.eclipse.wb.internal.core.utils.state.IOtherHelper;
import org.eclipse.wb.internal.core.utils.state.IParametersProvider;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;
import org.eclipse.wb.internal.core.utils.state.IPasteRequestProcessor;

public final class GlobalStateJava {
    private static final IParametersProvider m_parametersProvider = new IParametersProvider(){

        @Override
        public Map<String, String> getParameters(Object object) {
            if (object instanceof JavaInfo) {
                return JavaInfoUtils.getParameters((JavaInfo)object);
            }
            if (object instanceof ComponentDescription) {
                return ((ComponentDescription)object).getParameters();
            }
            return null;
        }

        @Override
        public String getParameter(Object object, String name) {
            if (object instanceof JavaInfo) {
                return JavaInfoUtils.getParameter((JavaInfo)object, name);
            }
            if (object instanceof ComponentDescription) {
                return ((ComponentDescription)object).getParameter(name);
            }
            return null;
        }

        @Override
        public boolean hasTrueParameter(Object object, String name) {
            if (object instanceof JavaInfo) {
                return JavaInfoUtils.hasTrueParameter((JavaInfo)object, name);
            }
            return false;
        }
    };
    private static final IDescriptionHelper m_descriptionHelper = new IDescriptionHelper(){

        @Override
        public PropertyEditor getEditorForType(Class<?> type) throws Exception {
            return DescriptionPropertiesHelper.getEditorForType(type);
        }

        @Override
        public IComponentDescription getDescription(Object object) {
            if (object instanceof JavaInfo) {
                return ((JavaInfo)object).getDescription();
            }
            return null;
        }
    };
    private static final ILayoutRequestValidatorHelper m_validatorHelper = new ILayoutRequestValidatorHelper(){

        public boolean isComponent(Object object) {
            return object instanceof JavaInfo;
        }

        public IComponentDescription getPasteComponentDescription(Object _memento) throws Exception {
            JavaInfoMemento memento = (JavaInfoMemento)_memento;
            JavaInfo activeJava = (JavaInfo)GlobalState.getActiveObject();
            return ComponentDescriptionHelper.getDescription(activeJava.getEditor(), memento.getComponentClassName());
        }

        public Object getPasteComponent(Object _memento) throws Exception {
            JavaInfoMemento memento = (JavaInfoMemento)_memento;
            JavaInfo activeJava = (JavaInfo)GlobalState.getActiveObject();
            return memento.create(activeJava);
        }

        public boolean canUseParentForChild(Object parent, Object child) throws Exception {
            if (parent instanceof JavaInfo && child instanceof JavaInfo) {
                JavaInfo parentJava = (JavaInfo)parent;
                JavaInfo childJava = (JavaInfo)child;
                return childJava.getCreationSupport().canUseParent(parentJava);
            }
            return true;
        }

        public boolean canReference(Object object) {
            if (object instanceof JavaInfo) {
                JavaInfo javaInfo = (JavaInfo)object;
                return !(javaInfo.getCreationSupport() instanceof IImplicitCreationSupport);
            }
            return false;
        }

        public boolean canReorder(ObjectInfo component) {
            return ((JavaInfo)component).getCreationSupport().canReorder();
        }

        public boolean canReparent(ObjectInfo component) {
            return ((JavaInfo)component).getCreationSupport().canReparent();
        }
    };
    private static final IPasteRequestProcessor m_pasteRequestProcessor = new IPasteRequestProcessor(){

        @Override
        public Command getPasteCommand(PasteRequest request, final IPasteComponentProcessor componentProcessor) {
            final List<IObjectInfo> components = this.getPastingComponents(request);
            if (components.isEmpty()) {
                return null;
            }
            ObjectInfo hierarchyObject = GlobalState.getActiveObject();
            return new EditCommand(hierarchyObject){

                protected void executeEdit() throws Exception {
                    for (IObjectInfo component : components) {
                        componentProcessor.process(component);
                        JavaInfoMemento.apply((JavaInfo)component.getUnderlyingModel());
                    }
                }
            };
        }

        @Override
        public List<IObjectInfo> getPastingComponents(PasteRequest request) {
            final List mementos = (List)request.getMemento();
            final List components = Lists.newArrayList();
            ExecutionUtils.runLog(new RunnableEx(){

                public void run() throws Exception {
                    JavaInfo hierarchyModel = (JavaInfo)GlobalState.getActiveObject();
                    for (JavaInfoMemento memento : mementos) {
                        JavaInfo component = memento.create(hierarchyModel);
                        components.add(component);
                    }
                }
            });
            request.setObjects(components);
            return components;
        }
    };
    private static final IOrderProcessor m_orderProcessor = new IOrderProcessor(){

        public void move(Object _component, Object _nextComponent) throws Exception {
            JavaInfo component = (JavaInfo)_component;
            JavaInfo nextComponent = (JavaInfo)_nextComponent;
            JavaInfo container = (JavaInfo)component.getParent();
            JavaInfoUtils.move(component, null, container, nextComponent);
        }
    };
    private static final IOtherHelper m_otherHelper = new IOtherHelper(){

        @Override
        public IJavaProject getJavaProject() {
            JavaInfo javaInfo = (JavaInfo)GlobalState.getActiveObject();
            return javaInfo.getEditor().getJavaProject();
        }

        @Override
        public Object getObject(ObjectInfo model) {
            if (model instanceof JavaInfo) {
                return ((JavaInfo)model).getObject();
            }
            return null;
        }

        @Override
        public List<EditorWarning> getWarnings() {
            return this.getState().getWarnings();
        }

        @Override
        public void addWarning(EditorWarning warning) {
            this.getState().addWarning(warning);
        }

        private EditorState getState() {
            JavaInfo javaInfo = (JavaInfo)GlobalState.getActiveObject();
            return JavaInfoUtils.getState(javaInfo);
        }
    };

    public static void activate(JavaInfo javaInfo) {
        EditorState.setActiveJavaInfo(javaInfo);
        GlobalState.setActiveObject(javaInfo);
        if (javaInfo != null) {
            GlobalState.setToolkit(javaInfo.getDescription().getToolkit());
            GlobalState.setClassLoader(JavaInfoUtils.getClassLoader(javaInfo));
        } else {
            GlobalState.setToolkit(null);
            GlobalState.setClassLoader(null);
        }
        GlobalState.setParametersProvider(m_parametersProvider);
        GlobalState.setDescriptionHelper(m_descriptionHelper);
        GlobalState.setValidatorHelper(m_validatorHelper);
        GlobalState.setPasteRequestProcessor(m_pasteRequestProcessor);
        GlobalState.setOrderProcessor(m_orderProcessor);
        GlobalState.setOtherHelper(m_otherHelper);
    }

    public static void deactivate(JavaInfo javaInfo) {
        if (GlobalState.getActiveObject() == javaInfo) {
            GlobalStateJava.deactivate();
        }
    }

    public static void deactivate() {
        EditorState.setActiveJavaInfo(null);
        GlobalState.setActiveObject(null);
        GlobalState.setToolkit(null);
        GlobalState.setClassLoader(null);
        GlobalState.setParametersProvider(null);
        GlobalState.setDescriptionHelper(null);
        GlobalState.setValidatorHelper(null);
        GlobalState.setPasteRequestProcessor(null);
        GlobalState.setOrderProcessor(null);
        GlobalState.setOtherHelper(null);
    }
}

