/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.event;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoEventListeners;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.event.AbstractComplexEventPropertyEditor;
import org.eclipse.wb.internal.core.model.property.event.AbstractListenerProperty;
import org.eclipse.wb.internal.core.model.property.event.EventsProperty;
import org.eclipse.wb.internal.core.model.property.event.ListenerInfo;
import org.eclipse.wb.internal.core.model.property.event.ListenerProperty;
import org.eclipse.wb.internal.core.model.util.GenericTypeResolverJavaInfo;
import org.eclipse.wb.internal.core.utils.GenericTypeResolver;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EventsPropertyEditor
extends AbstractComplexEventPropertyEditor {
    public static final EventsPropertyEditor INSTANCE = new EventsPropertyEditor();
    private static final ClassMap<List<ListenerInfo>> m_listenersCache = ClassMap.create();

    private EventsPropertyEditor() {
    }

    public AbstractListenerProperty[] getProperties(Property property) throws Exception {
        EventsProperty eventsProperty = (EventsProperty)property;
        JavaInfo javaInfo = eventsProperty.getJavaInfo();
        AbstractListenerProperty[] properties = (AbstractListenerProperty[])javaInfo.getArbitraryValue(eventsProperty);
        if (properties == null) {
            properties = this.createProperties(javaInfo);
            javaInfo.putArbitraryValue(eventsProperty, properties);
        }
        return properties;
    }

    private AbstractListenerProperty[] createProperties(JavaInfo javaInfo) throws Exception {
        List properties = Lists.newArrayList();
        for (ListenerInfo listener : EventsPropertyEditor.getListeners(javaInfo)) {
            properties.add(new ListenerProperty(javaInfo, listener));
        }
        javaInfo.getBroadcast(JavaInfoEventListeners.class).invoke(javaInfo, properties);
        return properties.toArray(new AbstractListenerProperty[properties.size()]);
    }

    private static List<ListenerInfo> getListeners(JavaInfo javaInfo) throws Exception {
        Class<?> componentClass = javaInfo.getDescription().getComponentClass();
        List<ListenerInfo> listeners = m_listenersCache.get(componentClass);
        if (listeners == null) {
            GenericTypeResolverJavaInfo externalResolver = new GenericTypeResolverJavaInfo(javaInfo);
            listeners = EventsPropertyEditor.getListeners(componentClass, externalResolver);
            m_listenersCache.put(componentClass, listeners);
        }
        return listeners;
    }

    private static List<ListenerInfo> getListeners(Class<?> componentClass, GenericTypeResolver externalResolver) {
        List<Method> methods = EventsPropertyEditor.get_addListener_methods(componentClass);
        List listeners = Lists.newArrayList();
        for (Method method : methods) {
            listeners.add(new ListenerInfo(method, componentClass, externalResolver));
        }
        ListenerInfo.useSimpleNamesWherePossible(listeners);
        Collections.sort(listeners, new Comparator<ListenerInfo>(){

            @Override
            public int compare(ListenerInfo listener_1, ListenerInfo listener_2) {
                return listener_1.getName().compareTo(listener_2.getName());
            }
        });
        return listeners;
    }

    private static List<Method> get_addListener_methods(Class<?> clazz) {
        List listenerMethods = Lists.newArrayList();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ListenerInfo.isAddListenerMethod(method)) {
                listenerMethods.add(method);
            }
            ++n2;
        }
        return listenerMethods;
    }
}

