/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.configurable;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.JavaProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.dialogs.StringsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringsAddPropertyEditor
extends TextDialogPropertyEditor
implements IConfigurablePropertyObject {
    private String m_addMethodSignature;
    private String[] m_removeMethodsSignatures;

    @Override
    protected String getText(Property property) throws Exception {
        Object[] items = this.getItems(property);
        return "[" + StringUtils.join((Object[])items, (String)",") + "]";
    }

    String[] getItems(Property _property) throws Exception {
        JavaInfo javaInfo = ((JavaProperty)_property).getJavaInfo();
        List<MethodInvocation> invocations = javaInfo.getMethodInvocations(this.m_addMethodSignature);
        ExecutionFlowDescription flowDescription = EditorState.get(javaInfo.getEditor()).getFlowDescription();
        JavaInfoUtils.sortNodesByFlow(flowDescription, false, invocations);
        List items = Lists.newArrayList();
        for (MethodInvocation invocation : invocations) {
            Expression itemExpression = DomGenerics.arguments(invocation).get(0);
            String item = (String)JavaInfoEvaluationHelper.getValue(itemExpression);
            items.add(item);
        }
        return items.toArray(new String[items.size()]);
    }

    void setItems(Property _property, final String[] items) throws Exception {
        final JavaInfo javaInfo = ((JavaProperty)_property).getJavaInfo();
        ExecutionUtils.run(javaInfo, new RunnableEx(){

            public void run() throws Exception {
                StringsAddPropertyEditor.this.setItems0(items, javaInfo);
            }
        });
    }

    private void setItems0(String[] items, JavaInfo javaInfo) throws Exception {
        javaInfo.removeMethodInvocations(this.m_addMethodSignature);
        String[] stringArray = this.m_removeMethodsSignatures;
        int n = this.m_removeMethodsSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String removeMethodSignature = stringArray[n2];
            javaInfo.removeMethodInvocations(removeMethodSignature);
            ++n2;
        }
        int i = items.length - 1;
        while (i >= 0) {
            String item = items[i];
            String itemSource = StringConverter.INSTANCE.toJavaSource(javaInfo, item);
            javaInfo.addMethodInvocation(this.m_addMethodSignature, itemSource);
            --i;
        }
    }

    @Override
    protected void openDialog(Property property) throws Exception {
        StringsDialog itemsDialog = new StringsDialog(DesignerPlugin.getShell(), DesignerPlugin.getDefault(), property.getTitle(), "String items:", "Each line in the above text field represents a single item.");
        itemsDialog.setItems(this.getItems(property));
        if (itemsDialog.open() == 0) {
            String[] items = itemsDialog.getItems();
            this.setItems(property, items);
        }
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        String addMethodName = (String)parameters.get("addMethod");
        Assert.isNotNull(addMethodName, "No 'addMethod' parameter in %s.", parameters);
        this.m_addMethodSignature = String.valueOf(addMethodName) + "(java.lang.String)";
        String removeMethodsString = (String)parameters.get("removeMethods");
        this.m_removeMethodsSignatures = removeMethodsString != null ? StringUtils.split((String)removeMethodsString) : ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

