/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvocationDescription
extends AbstractDescription {
    private final Class<?> m_declaringClass;
    private String m_name;
    private final List<ParameterDescription> m_parameters = Lists.newArrayList();
    private String m_signature;
    private boolean m_initialized;

    public AbstractInvocationDescription(Class<?> declaringClass) {
        this.m_declaringClass = declaringClass;
    }

    public final String toString() {
        return String.valueOf(this.m_name) + "(" + StringUtils.join(this.m_parameters.iterator(), (String)",") + ")";
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractInvocationDescription) {
            AbstractInvocationDescription description = (AbstractInvocationDescription)obj;
            return this.m_signature.equals(description.m_signature);
        }
        return false;
    }

    public final int hashCode() {
        return this.m_signature.hashCode();
    }

    public void join(AbstractInvocationDescription description) {
        List<ParameterDescription> newParameters = description.getParameters();
        int index = 0;
        while (index < this.m_parameters.size()) {
            ParameterDescription thisParameter = this.m_parameters.get(index);
            ParameterDescription newParameter = newParameters.get(index);
            thisParameter.join(newParameter);
            ++index;
        }
        this.putTags(description.getTags());
    }

    public final Class<?> getDeclaringClass() {
        return this.m_declaringClass;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public List<ParameterDescription> getParameters() {
        return this.m_parameters;
    }

    public ParameterDescription getParameter(int index) {
        return this.m_parameters.get(index);
    }

    public final void addParameter(ParameterDescription parameter) {
        this.m_parameters.add(parameter);
    }

    public List<String> getDefaultArguments() {
        List defaultArguments = Lists.newArrayList();
        for (ParameterDescription parameter : this.getParameters()) {
            String defaultArgument = parameter.getDefaultSource();
            defaultArguments.add(defaultArgument);
        }
        return defaultArguments;
    }

    public final String getSignature() {
        return this.m_signature;
    }

    public final void postProcess() {
        int index = 0;
        while (index < this.m_parameters.size()) {
            ParameterDescription parameter = this.m_parameters.get(index);
            parameter.setIndex(index);
            ++index;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_name);
        buffer.append("(");
        int i = 0;
        while (i < this.m_parameters.size()) {
            ParameterDescription parameter = this.m_parameters.get(i);
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append(ReflectionUtils.getFullyQualifiedName(parameter.getType(), false));
            ++i;
        }
        buffer.append(")");
        this.m_signature = buffer.toString();
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public void setInitialized(boolean initialized) {
        this.m_initialized = initialized;
    }

    @Override
    public final void visit(JavaInfo javaInfo, int state) throws Exception {
        super.visit(javaInfo, state);
        for (ParameterDescription parameter : this.m_parameters) {
            parameter.visit(javaInfo, state);
        }
    }
}

