/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef;

import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.gef.IEditPartConfigurator;
import org.eclipse.wb.core.gef.policy.DirectTextPropertyEditPolicy;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.internal.core.gef.policy.DblClickRunScriptEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.FlipBooleanPropertyEditPolicy;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public final class CoreEditPartConfigurator
implements IEditPartConfigurator {
    public void configure(EditPart context, EditPart editPart) {
        Object model = editPart.getModel();
        if (GlobalState.isComponent(model)) {
            ObjectInfo component = (ObjectInfo)model;
            this.configureFlipBooleanProperty(editPart, component);
            this.configure_onDoubleClick_runScript(editPart, component);
        }
        if (model instanceof AbstractComponentInfo) {
            AbstractComponentInfo item = (AbstractComponentInfo)model;
            DirectTextPropertyEditPolicy.install(editPart, item);
        }
    }

    private void configureFlipBooleanProperty(EditPart editPart, ObjectInfo component) {
        String propertyPath = GlobalState.getParametersProvider().getParameter(component, "double-click.flipBooleanProperty");
        if (!StringUtils.isEmpty((String)propertyPath)) {
            editPart.installEditPolicy(new FlipBooleanPropertyEditPolicy(component, propertyPath));
        }
    }

    private void configure_onDoubleClick_runScript(EditPart editPart, ObjectInfo component) {
        String propertyPath = GlobalState.getParametersProvider().getParameter(component, "double-click.runScript");
        if (!StringUtils.isEmpty((String)propertyPath)) {
            editPart.installEditPolicy(new DblClickRunScriptEditPolicy(component, propertyPath));
        }
    }
}

