/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class QualifiedNameEvaluator
implements IExpressionEvaluator {
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            Name qualifier = qualifiedName.getQualifier();
            String fieldName = qualifiedName.getName().getIdentifier();
            if ("length".equals(fieldName)) {
                Object arrayValue = AstEvaluationEngine.evaluate(context, (Expression)qualifier);
                int length = Array.getLength(arrayValue);
                return length;
            }
            String qualifierClassName = AstNodeUtils.getFullyQualifiedName((Expression)qualifier, true);
            Class<?> qualifierClass = context.getClassLoader().loadClass(qualifierClassName);
            Field field = ReflectionUtils.getFieldByName(qualifierClass, fieldName);
            Assert.isNotNull(field);
            if (ReflectionUtils.isStatic(field)) {
                return field.get(null);
            }
            Object qualifierValue = AstEvaluationEngine.evaluate(context, (Expression)qualifier);
            return field.get(qualifierValue);
        }
        return AstEvaluationEngine.UNKNOWN;
    }
}

