/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.structure.property;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.editor.structure.property.PropertyCategoryProviderProvider;
import org.eclipse.wb.core.editor.structure.property.PropertyListProcessor;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDeactivePropertyEditor;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.structure.IPage;
import org.eclipse.wb.internal.core.editor.structure.property.IPropertiesMenuContributor;
import org.eclipse.wb.internal.core.editor.structure.property.IPropertiesToolBarContributor;
import org.eclipse.wb.internal.core.editor.structure.property.PropertyListIntersector;
import org.eclipse.wb.internal.core.model.ObjectReferenceInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.PropertyManager;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProvider;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProviders;
import org.eclipse.wb.internal.core.model.property.table.IPropertyExceptionHandler;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentsPropertiesPage
implements IPage {
    private static final Property[] NO_PROPERTIES = new Property[0];
    private Composite m_container;
    private StackLayout m_stackLayout;
    private PropertyTable m_propertyTable;
    private PropertyTable m_eventsTable;
    private ObjectInfo m_rootObject;
    private final List<ObjectInfo> m_objects = Lists.newArrayList();
    private Property m_activeProperty;
    private IToolBarManager m_toolBarManager;
    private Action m_showAdvancedPropertiesAction;
    private SetCategoryAction m_setCategoryAction_default;
    private SetCategoryAction m_setCategoryAction_preferred;
    private SetCategoryAction m_setCategoryAction_normal;
    private SetCategoryAction m_setCategoryAction_advanced;
    private Action m_defaultValueAction;
    private Action m_showEventsAction;
    private boolean m_showEvents;

    @Override
    public void dispose() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.m_container = new Composite(parent, 0);
        this.m_stackLayout = new StackLayout();
        this.m_container.setLayout((Layout)this.m_stackLayout);
        IPropertyExceptionHandler exceptionHandler = new IPropertyExceptionHandler(){

            public void handle(Throwable e) {
                IDesignPageSite site = IDesignPageSite.Helper.getSite(ComponentsPropertiesPage.this.m_rootObject);
                site.handleException(e);
            }
        };
        this.m_propertyTable = new PropertyTable(this.m_container, 0);
        this.m_propertyTable.setExceptionHandler(exceptionHandler);
        this.m_eventsTable = new PropertyTable(this.m_container, 0);
        this.m_eventsTable.setExceptionHandler(exceptionHandler);
        this.m_stackLayout.topControl = this.m_propertyTable;
        this.m_container.layout();
        this.createActions();
        this.setPropertyTableContextMenu();
    }

    @Override
    public Control getControl() {
        return this.m_container;
    }

    @Override
    public void setFocus() {
        this.getControl().setFocus();
    }

    @Override
    public void setToolBar(IToolBarManager toolBarManager) {
        this.m_toolBarManager = toolBarManager;
        this.updateActions();
    }

    private void createActions() {
        this.create_showEventsAction();
        this.create_showAdvancedPropertiesAction();
        this.create_setCategoryAction();
        this.create_defaultValueAction();
        this.trackPropertySelection();
    }

    private void updateActions() {
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                ComponentsPropertiesPage.this.update_showEventsAction();
                ComponentsPropertiesPage.this.update_categoryAction();
                ComponentsPropertiesPage.this.update_defaultValueAction();
                ToolBar toolBarControl = ((ToolBarManager)ComponentsPropertiesPage.this.m_toolBarManager).getControl();
                try {
                    toolBarControl.setRedraw(false);
                    ComponentsPropertiesPage.this.m_toolBarManager.removeAll();
                    ComponentsPropertiesPage.this.m_toolBarManager.add((IAction)ComponentsPropertiesPage.this.m_showEventsAction);
                    ComponentsPropertiesPage.this.m_toolBarManager.add((IContributionItem)new Separator("org.eclipse.wb.component-properties.group.edit"));
                    ComponentsPropertiesPage.this.m_toolBarManager.add((IContributionItem)new Separator("org.eclipse.wb.component-properties.group.additional"));
                    ComponentsPropertiesPage.this.m_toolBarManager.add((IAction)ComponentsPropertiesPage.this.m_showAdvancedPropertiesAction);
                    ComponentsPropertiesPage.this.m_toolBarManager.add((IAction)ComponentsPropertiesPage.this.m_defaultValueAction);
                    List<IPropertiesToolBarContributor> contributors = ExternalFactoriesHelper.getElementsInstances(IPropertiesToolBarContributor.class, "org.eclipse.wb.core.propertiesPageActions", "toolbar");
                    for (final IPropertiesToolBarContributor contributor : contributors) {
                        ExecutionUtils.runLog(new RunnableEx(){

                            public void run() throws Exception {
                                contributor.contributeToolBar(ComponentsPropertiesPage.this.m_toolBarManager, ComponentsPropertiesPage.this.m_objects);
                            }
                        });
                    }
                    ComponentsPropertiesPage.this.m_toolBarManager.update(false);
                }
                finally {
                    toolBarControl.setRedraw(true);
                }
            }
        });
    }

    private void setPropertyTableContextMenu() {
        final MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager _manager) {
                MenuItem[] menuItemArray = manager.getMenu().getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                this.fillContextMenu();
            }

            private void fillContextMenu() {
                manager.add((IContributionItem)new Separator("org.eclipse.wb.component-properties.group.top"));
                manager.add((IContributionItem)new Separator("org.eclipse.wb.component-properties.group.edit"));
                manager.add((IAction)ComponentsPropertiesPage.this.m_defaultValueAction);
                manager.add((IAction)ComponentsPropertiesPage.this.m_showAdvancedPropertiesAction);
                manager.add((IContributionItem)new Separator("org.eclipse.wb.component-properties.group.priority"));
                manager.add((IAction)ComponentsPropertiesPage.this.m_setCategoryAction_default);
                manager.add((IAction)ComponentsPropertiesPage.this.m_setCategoryAction_preferred);
                manager.add((IAction)ComponentsPropertiesPage.this.m_setCategoryAction_normal);
                manager.add((IAction)ComponentsPropertiesPage.this.m_setCategoryAction_advanced);
                manager.add((IContributionItem)new Separator("org.eclipse.wb.component-properties.group.additional"));
                List<IPropertiesMenuContributor> contributors = ExternalFactoriesHelper.getElementsInstances(IPropertiesMenuContributor.class, "org.eclipse.wb.core.propertiesPageActions", "menu");
                for (final IPropertiesMenuContributor contributor : contributors) {
                    ExecutionUtils.runLog(new RunnableEx(){

                        public void run() throws Exception {
                            contributor.contributeMenu((IMenuManager)manager, ComponentsPropertiesPage.this.m_activeProperty);
                        }
                    });
                }
            }
        });
        this.m_propertyTable.setMenu(manager.createContextMenu((Control)this.m_propertyTable));
    }

    private void trackPropertySelection() {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ComponentsPropertiesPage.this.m_activeProperty = (Property)selection.getFirstElement();
                ExecutionUtils.runLog(new RunnableEx(){

                    public void run() throws Exception {
                        ComponentsPropertiesPage.this.update_defaultValueAction();
                        ComponentsPropertiesPage.this.update_categoryAction();
                    }
                });
            }
        };
        this.m_propertyTable.addSelectionChangedListener(listener);
        this.m_eventsTable.addSelectionChangedListener(listener);
    }

    private static void setTexts(IAction action, String text) {
        action.setText(text);
        action.setToolTipText(text);
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        this.m_objects.clear();
        int i = 0;
        for (ObjectInfo objectInfo : structuredSelection) {
            if (objectInfo instanceof ObjectReferenceInfo) {
                objectInfo = ((ObjectReferenceInfo)objectInfo).getObject();
            }
            if (!objectInfo.isDeleted()) {
                this.m_objects.add(objectInfo);
            }
            ++i;
        }
        if (this.m_objects.isEmpty()) {
            this.m_rootObject = null;
            this.m_propertyTable.setInput(null);
        } else {
            this.m_rootObject = this.m_objects.get(0).getRoot();
            this.m_rootObject.addBroadcastListener(new ObjectEventListener(){

                public void refreshed() throws Exception {
                    ComponentsPropertiesPage.this.refreshProperties();
                }

                public void presentationChanged() throws Exception {
                    ComponentsPropertiesPage.this.refreshProperties();
                }
            });
            this.deactivatePropertyEditor_whenDelete();
            this.deactivatePropertyEditor_whenDispose();
            this.deactivatePropertyEditor_whenExplicitlyRequested();
        }
        this.refreshProperties();
    }

    private void deactivatePropertyEditor_whenDelete() {
        this.m_rootObject.addBroadcastListener(new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                boolean deleteDisplayedObject = ComponentsPropertiesPage.this.m_objects.contains(child);
                if (deleteDisplayedObject) {
                    ComponentsPropertiesPage.this.m_propertyTable.deactivateEditor(false);
                }
            }
        });
    }

    private void deactivatePropertyEditor_whenDispose() {
        this.m_rootObject.addBroadcastListener(new ObjectEventListener(){

            public void dispose_beforePresentation() throws Exception {
                ComponentsPropertiesPage.this.m_propertyTable.deactivateEditor(false);
            }
        });
    }

    private void deactivatePropertyEditor_whenExplicitlyRequested() {
        this.m_rootObject.addBroadcastListener(new ObjectInfoDeactivePropertyEditor(){

            public void invoke() throws Exception {
                ComponentsPropertiesPage.this.m_propertyTable.deactivateEditor(false);
            }
        });
    }

    private void create_showAdvancedPropertiesAction() {
        this.m_showAdvancedPropertiesAction = new Action("", 2){

            public void run() {
                boolean show = ComponentsPropertiesPage.this.m_showAdvancedPropertiesAction.isChecked();
                ComponentsPropertiesPage.this.m_propertyTable.setShowAdvancedProperties(show);
            }
        };
        this.m_showAdvancedPropertiesAction.setImageDescriptor(DesignerPlugin.getImageDescriptor("structure/filter_advanced_properties.gif"));
        ComponentsPropertiesPage.setTexts((IAction)this.m_showAdvancedPropertiesAction, Messages.ComponentsPropertiesPage_showAdvancedAction);
    }

    private void create_setCategoryAction() {
        this.m_setCategoryAction_default = new SetCategoryAction(Messages.ComponentsPropertiesPage_useDefaultCategoryAction, null);
        this.m_setCategoryAction_preferred = new SetCategoryAction(Messages.ComponentsPropertiesPage_markAsPreferredAction, PropertyCategory.PREFERRED);
        this.m_setCategoryAction_normal = new SetCategoryAction(Messages.ComponentsPropertiesPage_markAsNormalAction, PropertyCategory.NORMAL);
        this.m_setCategoryAction_advanced = new SetCategoryAction(Messages.ComponentsPropertiesPage_markAsAdvancedAction, PropertyCategory.ADVANCED);
    }

    private void update_categoryAction() throws Exception {
        this.m_setCategoryAction_default.update();
        this.m_setCategoryAction_preferred.update();
        this.m_setCategoryAction_normal.update();
        this.m_setCategoryAction_advanced.update();
    }

    private void create_defaultValueAction() {
        this.m_defaultValueAction = new Action(){

            public void run() {
                ExecutionUtils.run(ComponentsPropertiesPage.this.m_rootObject, new RunnableEx(){

                    public void run() throws Exception {
                        ComponentsPropertiesPage.this.m_activeProperty.setValue(Property.UNKNOWN_VALUE);
                    }
                });
            }
        };
        this.m_defaultValueAction.setImageDescriptor(DesignerPlugin.getImageDescriptor("structure/properties_default.gif"));
        ComponentsPropertiesPage.setTexts((IAction)this.m_defaultValueAction, Messages.ComponentsPropertiesPage_restoreDefaultAction);
    }

    private void update_defaultValueAction() throws Exception {
        if (this.m_activeProperty != null) {
            this.m_defaultValueAction.setEnabled(this.m_activeProperty.isModified());
        } else {
            this.m_defaultValueAction.setEnabled(false);
        }
    }

    private void create_showEventsAction() {
        this.m_showEventsAction = new Action(){

            public void run() {
                ComponentsPropertiesPage.this.m_showEvents = !ComponentsPropertiesPage.this.m_showEvents;
                ComponentsPropertiesPage.this.m_showEventsAction.setChecked(ComponentsPropertiesPage.this.m_showEvents);
                ComponentsPropertiesPage.this.refreshProperties();
                if (ComponentsPropertiesPage.this.m_showEvents) {
                    ComponentsPropertiesPage.this.m_eventsTable.setFocus();
                } else {
                    ComponentsPropertiesPage.this.m_propertyTable.setFocus();
                }
            }
        };
        this.m_showEventsAction.setImageDescriptor(DesignerPlugin.getImageDescriptor("structure/events.gif"));
        ComponentsPropertiesPage.setTexts((IAction)this.m_showEventsAction, Messages.ComponentsPropertiesPage_showEventsAction);
        this.m_showEventsAction.setChecked(this.m_showEvents);
    }

    private void update_showEventsAction() throws Exception {
        boolean isValid = this.m_objects.size() == 1;
        this.m_showEventsAction.setEnabled(isValid);
    }

    private void refreshProperties() {
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                if (ComponentsPropertiesPage.this.m_showEvents) {
                    ComponentsPropertiesPage.this.showEvents();
                } else {
                    ComponentsPropertiesPage.this.showProperties();
                }
                ComponentsPropertiesPage.this.updateActions();
            }
        });
    }

    private void showEvents() throws Exception {
        Property[] properties = null;
        if (this.m_objects.size() == 1) {
            Property eventsProperty = this.m_objects.get(0).getPropertyByTitle("Events");
            properties = PropertyUtils.getChildren(eventsProperty);
        }
        this.m_eventsTable.setInput(properties);
        this.m_stackLayout.topControl = this.m_eventsTable;
        this.m_container.layout();
    }

    private void showProperties() throws Exception {
        List propertyList = Lists.newArrayList();
        Collections.addAll(propertyList, this.getAllProperties());
        this.preparePropertiesForDisplaying(propertyList);
        Property[] properties = propertyList.toArray(new Property[propertyList.size()]);
        this.m_propertyTable.setInput(properties);
        this.m_stackLayout.topControl = this.m_propertyTable;
        this.m_container.layout();
    }

    private void preparePropertiesForDisplaying(List<Property> properties) {
        final PropertyCategoryProvider provider = this.getPropertyCategoryProvider();
        this.m_propertyTable.setPropertyCategoryProvider(provider);
        Collections.sort(properties, new Comparator<Property>(){

            @Override
            public int compare(Property property_1, Property property_2) {
                PropertyCategory category_1 = provider.getCategory(property_1);
                PropertyCategory category_2 = provider.getCategory(property_2);
                boolean system_1 = category_1.isSystem();
                boolean system_2 = category_2.isSystem();
                if (system_1 && system_2) {
                    return category_1.getPriority() - category_2.getPriority();
                }
                if (system_1) {
                    return -1;
                }
                if (system_2) {
                    return 1;
                }
                return 0;
            }
        });
        List<PropertyListProcessor> processors = ExternalFactoriesHelper.getElementsInstances(PropertyListProcessor.class, "org.eclipse.wb.core.propertiesPageProcessors", "processor");
        for (PropertyListProcessor processor : processors) {
            processor.process(this.m_objects, properties);
        }
    }

    private PropertyCategoryProvider getPropertyCategoryProvider() {
        List<PropertyCategoryProviderProvider> providers2 = ExternalFactoriesHelper.getElementsInstances(PropertyCategoryProviderProvider.class, "org.eclipse.wb.core.propertiesPageCategoryProviders", "provider");
        for (PropertyCategoryProviderProvider provider2 : providers2) {
            PropertyCategoryProvider provider = provider2.get(this.m_objects);
            if (provider == null) continue;
            return provider;
        }
        return PropertyCategoryProviders.def();
    }

    private Property[] getAllProperties() throws Exception {
        if (this.m_objects.size() == 0) {
            return NO_PROPERTIES;
        }
        if (this.m_objects.size() == 1) {
            return ComponentsPropertiesPage.getProperties(this.m_objects.get(0));
        }
        PropertyListIntersector intersector = new PropertyListIntersector();
        for (ObjectInfo objectInfo : this.m_objects) {
            intersector.intersect(ComponentsPropertiesPage.getProperties(objectInfo));
        }
        return intersector.getProperties();
    }

    private static Property[] getProperties(ObjectInfo object) throws Exception {
        if (!object.isDeleted()) {
            return object.getProperties();
        }
        return NO_PROPERTIES;
    }

    private class SetCategoryAction
    extends Action {
        private final PropertyCategory m_category;

        public SetCategoryAction(String text, PropertyCategory category) {
            super(text, category != null ? 8 : 0);
            this.m_category = category;
        }

        public void run() {
            PropertyManager.setCategory(ComponentsPropertiesPage.this.m_activeProperty, this.m_category);
            ComponentsPropertiesPage.this.m_propertyTable.redraw();
        }

        private void update() {
            this.setEnabled(ComponentsPropertiesPage.this.m_activeProperty != null);
            if (ComponentsPropertiesPage.this.m_activeProperty != null) {
                this.setChecked(PropertyManager.getCategory(ComponentsPropertiesPage.this.m_activeProperty) == this.m_category);
            }
        }
    }
}

