/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.command;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command {
    private StringBuffer m_stringBuffer;

    public abstract void execute(PaletteInfo var1);

    public final String toString() {
        this.m_stringBuffer = new StringBuffer();
        this.m_stringBuffer.append("\t<");
        ExecutionUtils.runRethrow(new RunnableEx(){

            public void run() throws Exception {
                String id = (String)Command.this.getClass().getField("ID").get(null);
                Command.this.m_stringBuffer.append(id);
            }
        });
        this.addAttributes();
        this.m_stringBuffer.append("/>");
        return this.m_stringBuffer.toString();
    }

    protected final void addAttribute(String name, boolean value) {
        this.addAttribute(name, value ? "true" : "false");
    }

    protected final void addAttribute(String name, String value) {
        if (value != null) {
            this.m_stringBuffer.append("\n\t\t");
            this.m_stringBuffer.append(name);
            this.m_stringBuffer.append("=\"");
            value = StringEscapeUtils.escapeXml((String)value);
            StringBuilder escaped = new StringBuilder();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c < ' ') {
                    escaped.append("&#");
                    escaped.append((int)c);
                    escaped.append(";");
                } else {
                    escaped.append(c);
                }
                ++i;
            }
            value = escaped.toString();
            this.m_stringBuffer.append(value);
            this.m_stringBuffer.append("\"");
        }
    }

    protected abstract void addAttributes();

    public void addToCommandList(List<Command> commands) {
        commands.add(this);
    }

    protected final void removeCommands(List<Command> commands, Class<? extends Command> commandClass, String id) throws Exception {
        Field idField = ReflectionUtils.getFieldByName(commandClass, "m_id");
        Iterator<Command> I = commands.iterator();
        while (I.hasNext()) {
            Command command = I.next();
            if (command.getClass() != commandClass || !idField.get(command).equals(id)) continue;
            I.remove();
        }
    }
}

