/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.actions.ActionUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMementoTransfer;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyAction
extends Action {
    private final IEditPartViewer m_viewer;
    private List<JavaInfoMemento> m_mementos;

    public CopyAction(IEditPartViewer viewer) {
        this.m_viewer = viewer;
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CopyAction.this.firePropertyChange("enabled", null, CopyAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
            }
        });
        ActionUtils.copyPresentation((IAction)this, ActionFactory.COPY);
    }

    public void run() {
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                List<EditPart> editParts = CopyAction.this.m_viewer.getSelectedEditParts();
                CopyAction.this.m_mementos = CopyAction.getMementos(editParts);
                CopyAction.doCopy(CopyAction.this.m_mementos);
            }
        });
    }

    public boolean isEnabled() {
        List<EditPart> editParts = this.m_viewer.getSelectedEditParts();
        return CopyAction.hasMementos(editParts);
    }

    static void doCopy(List<JavaInfoMemento> mementos) {
        if (mementos != null) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                clipboard.setContents(new Object[]{mementos}, new Transfer[]{JavaInfoMementoTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    static boolean hasMementos(final List<EditPart> editParts) {
        return ExecutionUtils.runObjectLog(new RunnableObjectEx<Boolean>(){

            @Override
            public Boolean runObject() throws Exception {
                if (editParts.isEmpty()) {
                    return false;
                }
                for (EditPart editPart : editParts) {
                    Object model = editPart.getModel();
                    if (!(model instanceof JavaInfo)) {
                        return false;
                    }
                    JavaInfo javaInfo = (JavaInfo)model;
                    if (JavaInfoMemento.hasMemento(javaInfo)) continue;
                    return false;
                }
                return true;
            }
        }, false);
    }

    static List<JavaInfoMemento> getMementos(final List<EditPart> editParts) {
        return ExecutionUtils.runObjectLog(new RunnableObjectEx(){

            public Object runObject() throws Exception {
                return CopyAction.getMemento0(editParts);
            }
        }, null);
    }

    private static List<JavaInfoMemento> getMemento0(List<EditPart> editParts) throws Exception {
        List objects = Lists.newArrayList();
        for (EditPart editPart : editParts) {
            Object model = editPart.getModel();
            if (!(model instanceof JavaInfo)) {
                return null;
            }
            JavaInfo object = (JavaInfo)model;
            objects.add(object);
        }
        Iterator I = objects.iterator();
        while (I.hasNext()) {
            JavaInfo object = (JavaInfo)I.next();
            if (object.getParent(objects) == null) continue;
            I.remove();
        }
        List mementos = Lists.newArrayList();
        for (JavaInfo object : objects) {
            JavaInfoMemento memento = JavaInfoMemento.createMemento(object);
            mementos.add(memento);
        }
        return mementos;
    }
}

