/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Translatable;

public final class Rectangle
implements Translatable,
Serializable {
    private static final long serialVersionUID = 0L;
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
    }

    public Rectangle(Point location, Dimension size) {
        this(location.x, location.y, size.width, size.height);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle(org.eclipse.swt.graphics.Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Point point1, Point point2) {
        this.setLocation(point1);
        this.union(point2);
    }

    public Rectangle getCopy() {
        return new Rectangle(this);
    }

    public org.eclipse.swt.graphics.Rectangle getSwtRectangle() {
        return new org.eclipse.swt.graphics.Rectangle(this.x, this.y, this.width, this.height);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle setBounds(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        return this;
    }

    public Rectangle setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public Rectangle setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
        return this;
    }

    public Rectangle setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Rectangle setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        return this;
    }

    public Rectangle setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public void moveX(int deltaX) {
        this.x += deltaX;
        this.width -= deltaX;
    }

    public void moveY(int deltaY) {
        this.y += deltaY;
        this.height -= deltaY;
    }

    public void setX(int x) {
        this.width += this.x - x;
        this.x = x;
    }

    public int left() {
        return this.x;
    }

    public int right() {
        return this.x + this.width;
    }

    public void setRight(int right) {
        this.width = right - this.x;
    }

    public void setY(int y) {
        this.height += this.y - y;
        this.y = y;
    }

    public int top() {
        return this.y;
    }

    public int bottom() {
        return this.y + this.height;
    }

    public void setBottom(int bottom) {
        this.height = bottom - this.y;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int _x, int _y) {
        return _x >= this.x && _y >= this.y && _x < this.x + this.width && _y < this.y + this.height;
    }

    public boolean intersects(Rectangle rect) {
        return rect.x < this.x + this.width && rect.y < this.y + this.height && rect.x + rect.width > this.x && rect.y + rect.height > this.y;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean touches(Rectangle rectangle) {
        return rectangle.x <= this.x + this.width && rectangle.y <= this.y + this.height && rectangle.x + rectangle.width >= this.x && rectangle.y + rectangle.height >= this.y;
    }

    public Rectangle crop(Insets insets) {
        if (insets == null) {
            return this;
        }
        this.x += insets.left;
        this.y += insets.top;
        this.width -= insets.getWidth();
        this.height -= insets.getHeight();
        return this;
    }

    public Rectangle expand(int hIncrement, int vIncrement) {
        return this.shrink(-hIncrement, -vIncrement);
    }

    public Rectangle expand(Insets insets) {
        this.x -= insets.left;
        this.y -= insets.top;
        this.height += insets.getHeight();
        this.width += insets.getWidth();
        return this;
    }

    public Rectangle intersect(Rectangle rect) {
        int x1 = Math.max(this.x, rect.x);
        int x2 = Math.min(this.x + this.width, rect.x + rect.width);
        int y1 = Math.max(this.y, rect.y);
        int y2 = Math.min(this.y + this.height, rect.y + rect.height);
        if (x2 - x1 < 0 || y2 - y1 < 0) {
            this.height = 0;
            this.width = 0;
            this.y = 0;
            this.x = 0;
        } else {
            this.x = x1;
            this.y = y1;
            this.width = x2 - x1;
            this.height = y2 - y1;
        }
        return this;
    }

    public Rectangle resize(Dimension sizeDelta) {
        this.width += sizeDelta.width;
        this.height += sizeDelta.height;
        return this;
    }

    public Rectangle resize(int dw, int dh) {
        this.width += dw;
        this.height += dh;
        return this;
    }

    public final Rectangle scale(double scaleFactor) {
        return this.scale(scaleFactor, scaleFactor);
    }

    public Rectangle scale(double scaleX, double scaleY) {
        int oldX = this.x;
        int oldY = this.y;
        this.x = (int)Math.floor((double)this.x * scaleX);
        this.y = (int)Math.floor((double)this.y * scaleY);
        this.width = (int)Math.ceil((double)(oldX + this.width) * scaleX) - this.x;
        this.height = (int)Math.ceil((double)(oldY + this.height) * scaleY) - this.y;
        return this;
    }

    public Rectangle shrink(int h, int v) {
        this.x += h;
        this.width -= h + h;
        this.y += v;
        this.height -= v + v;
        return this;
    }

    public Rectangle transpose() {
        int temp = this.x;
        this.x = this.y;
        this.y = temp;
        temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public Rectangle union(Dimension dimension) {
        this.width = Math.max(this.width, dimension.width);
        this.height = Math.max(this.height, dimension.height);
        return this;
    }

    public Rectangle union(int x1, int y1) {
        if (x1 < this.x) {
            this.width += this.x - x1;
            this.x = x1;
        } else {
            int right = this.x + this.width;
            if (x1 >= right) {
                right = x1 + 1;
                this.width = right - this.x;
            }
        }
        if (y1 < this.y) {
            this.height += this.y - y1;
            this.y = y1;
        } else {
            int bottom = this.y + this.height;
            if (y1 >= bottom) {
                bottom = y1 + 1;
                this.height = bottom - this.y;
            }
        }
        return this;
    }

    public final void union(Point point) {
        this.union(point.x, point.y);
    }

    public final Rectangle union(Rectangle rectangle) {
        if (rectangle == null) {
            return this;
        }
        return this.union(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle union(int _x, int _y, int _w, int _h) {
        int right = Math.max(this.x + this.width, _x + _w);
        int bottom = Math.max(this.y + this.height, _y + _h);
        this.x = Math.min(this.x, _x);
        this.y = Math.min(this.y, _y);
        this.width = right - this.x;
        this.height = bottom - this.y;
        return this;
    }

    public void translate(Point point) {
        this.x += point.x;
        this.y += point.y;
    }

    public void translate(Dimension dimension) {
        this.x += dimension.width;
        this.y += dimension.height;
    }

    public void translate(Insets insets) {
        this.x += insets.left;
        this.y += insets.top;
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Point getBottom() {
        return new Point(this.x + this.width / 2, this.bottom());
    }

    public Point getBottomLeft() {
        return new Point(this.x, this.y + this.height);
    }

    public Point getBottomRight() {
        return new Point(this.x + this.width, this.y + this.height);
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2, this.y + this.height / 2);
    }

    public Rectangle getCropped(Insets insets) {
        Rectangle rectangle = new Rectangle(this);
        rectangle.crop(insets);
        return rectangle;
    }

    public Rectangle getExpanded(int hIncrement, int vIncrement) {
        return new Rectangle(this).expand(hIncrement, vIncrement);
    }

    public Rectangle getExpanded(Insets insets) {
        return new Rectangle(this).expand(insets);
    }

    public Rectangle getIntersection(Rectangle rectangle) {
        int x1 = Math.max(this.x, rectangle.x);
        int x2 = Math.min(this.x + this.width, rectangle.x + rectangle.width);
        int y1 = Math.max(this.y, rectangle.y);
        int y2 = Math.min(this.y + this.height, rectangle.y + rectangle.height);
        if (x2 - x1 < 0 || y2 - y1 < 0) {
            return new Rectangle();
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public Point getLeft() {
        return new Point(this.x, this.y + this.height / 2);
    }

    public Rectangle getResized(int w, int h) {
        return new Rectangle(this).resize(w, h);
    }

    public Rectangle getResized(Dimension dimension) {
        return new Rectangle(this).resize(dimension);
    }

    public Point getRight() {
        return new Point(this.right(), this.y + this.height / 2);
    }

    public Point getTop() {
        return new Point(this.x + this.width / 2, this.y);
    }

    public Point getTopLeft() {
        return new Point(this.x, this.y);
    }

    public Point getTopRight() {
        return new Point(this.x + this.width, this.y);
    }

    public Rectangle getTranslated(int dx, int dy) {
        Rectangle rectangle = new Rectangle(this);
        rectangle.translate(dx, dy);
        return rectangle;
    }

    public Rectangle getTranslated(Point point) {
        Rectangle rectangle = new Rectangle(this);
        rectangle.translate(point);
        return rectangle;
    }

    public Rectangle getTransposed() {
        Rectangle rectangle = new Rectangle(this);
        rectangle.transpose();
        return rectangle;
    }

    public Rectangle getUnion(Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty()) {
            return new Rectangle(this);
        }
        Rectangle union = new Rectangle(Math.min(this.x, rectangle.x), Math.min(this.y, rectangle.y), 0, 0);
        union.width = Math.max(this.x + this.width, rectangle.x + rectangle.width) - union.x;
        union.height = Math.max(this.y + this.height, rectangle.y + rectangle.height) - union.y;
        return union;
    }

    public Interval getInterval(boolean isHorizontal) {
        return isHorizontal ? new Interval(this.x, this.width) : new Interval(this.y, this.height);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return false;
    }

    public int hashCode() {
        return this.x + this.y + this.width + this.height;
    }

    public String toString() {
        return "Rectangle(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

