/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model;

import java.util.List;
import org.eclipse.wb.core.model.IWrapperInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.WrapperByMethod;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.EditorStateLoadingContext;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.utils.state.EditorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperMethodInfo
extends JavaInfo
implements IWrapperInfo {
    private boolean m_deleting = false;
    private WrapperByMethod m_wrapper;
    private static final ClassMap<Boolean> m_hasSpecialDescription = new ClassMap();

    public WrapperMethodInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new JavaEventListener(){

            @Override
            public void clipboardCopy(JavaInfo source, List<ClipboardCommand> commands) throws Exception {
                if (source == WrapperMethodInfo.this.getParent() && !(source.getCreationSupport() instanceof WrapperMethodControlCreationSupport)) {
                    WrapperMethodInfo.this.clipboardCopy_addCommands(commands);
                }
            }
        });
    }

    private void clipboardCopy_addCommands(List<ClipboardCommand> commands) throws Exception {
        final JavaInfoMemento wrapperMemento = JavaInfoMemento.createMemento(this);
        commands.add(new ClipboardCommand(){
            private static final long serialVersionUID = 0L;

            public void execute(JavaInfo javaInfo) throws Exception {
                WrapperMethodInfo viewer = (WrapperMethodInfo)wrapperMemento.create(javaInfo);
                JavaInfoUtils.add(viewer, new LocalUniqueVariableSupport(viewer), PureFlatStatementGenerator.INSTANCE, null, javaInfo, null);
                wrapperMemento.apply();
            }
        });
    }

    @Override
    public void delete() throws Exception {
        JavaInfo wrapped;
        if (!this.m_deleting && !(wrapped = this.getWrapper().getWrappedInfo()).isDeleting()) {
            this.m_deleting = true;
            try {
                wrapped.delete();
            }
            finally {
                this.m_deleting = false;
            }
            return;
        }
        super.delete();
    }

    @Override
    public WrapperByMethod getWrapper() {
        if (this.m_wrapper == null) {
            this.m_wrapper = this.createWrapper();
        }
        return this.m_wrapper;
    }

    protected WrapperByMethod createWrapper() {
        return new WrapperByMethod(this);
    }

    public static boolean isWrapper(AstEditor editor, Class<?> clazz) throws Exception {
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        if (WrapperMethodInfo.hasSpecialDescription(context, clazz)) {
            ComponentDescription description = ComponentDescriptionHelper.getDescription(editor, clazz);
            return WrapperMethodInfo.class.isAssignableFrom(description.getModelClass());
        }
        return false;
    }

    private static boolean hasSpecialDescription(ILoadingContext context, Class<?> clazz) throws Exception {
        if (clazz == Object.class) {
            return false;
        }
        if (clazz.isInterface()) {
            return false;
        }
        Boolean result = m_hasSpecialDescription.get(clazz);
        if (result == null) {
            result = WrapperMethodInfo.hasSpecialDescription0(context, clazz);
            m_hasSpecialDescription.put(clazz, result);
        }
        return result;
    }

    private static boolean hasSpecialDescription0(ILoadingContext context, Class<?> clazz) throws Exception {
        boolean hasDescription = DescriptionHelper.hasComponentDescriptionResource(context, clazz);
        if (hasDescription) {
            return true;
        }
        return WrapperMethodInfo.hasSpecialDescription(context, clazz.getSuperclass());
    }
}

