/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.eval;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionFlowDescription {
    private final List<MethodDeclaration> m_startMethods;
    private final Map<ASTNode, List<MethodDeclaration>> m_binaryFlowMethodsAfter = Maps.newHashMap();
    private final Map<ASTNode, List<MethodDeclaration>> m_binaryFlowMethodsBefore = Maps.newHashMap();
    private boolean m_binaryFlowLocked;
    private final LinkedList<Statement> m_traceStatements = Lists.newLinkedList();
    private int m_modificationCount;

    public ExecutionFlowDescription(MethodDeclaration ... startMethods) {
        this(Lists.newArrayList((Object[])startMethods));
    }

    public ExecutionFlowDescription(List<MethodDeclaration> startMethods) {
        this.m_startMethods = startMethods;
    }

    public int modificationCount() {
        return this.m_modificationCount;
    }

    public List<MethodDeclaration> getStartMethods() {
        AstNodeUtils.removeDanglingNodes(this.m_startMethods);
        return this.m_startMethods;
    }

    public void addStartMethod(MethodDeclaration method) {
        ++this.m_modificationCount;
        this.m_startMethods.add(method);
    }

    public boolean isStatic() {
        return AstNodeUtils.isStatic((BodyDeclaration)this.getFirstMethod());
    }

    public TypeDeclaration geTypeDeclaration() {
        return AstNodeUtils.getEnclosingType((ASTNode)this.getFirstMethod());
    }

    public CompilationUnit getCompilationUnit() {
        return (CompilationUnit)this.getFirstMethod().getRoot();
    }

    public AST getAST() {
        return this.getFirstMethod().getAST();
    }

    private MethodDeclaration getFirstMethod() {
        return this.m_startMethods.get(0);
    }

    public List<Statement> getTraceStatements() {
        return this.m_traceStatements;
    }

    private Statement getCurrentStatement() {
        Assert.isTrue(!this.m_traceStatements.isEmpty(), "Statements trace is empty!");
        return this.m_traceStatements.getFirst();
    }

    public void enterStatement(Statement statement) {
        this.m_traceStatements.addFirst(statement);
    }

    public void leaveStatement(Statement statement) {
        Assert.isTrue(!this.m_traceStatements.isEmpty(), "Statements trace is empty!");
        Statement lastStatement = this.m_traceStatements.removeFirst();
        Assert.isTrue(lastStatement == statement, "Execution flow problem. %s expected, but %s found.", statement, lastStatement);
    }

    public boolean isBinaryFlowLocked() {
        return this.m_binaryFlowLocked;
    }

    public void lockBinaryFlow() {
        this.m_binaryFlowLocked = true;
    }

    public void addBinaryFlowMethodBefore(MethodDeclaration methodDeclaration) {
        ++this.m_modificationCount;
        Statement currentStatement = this.getCurrentStatement();
        this.addBinaryFlowMethodBefore(currentStatement, methodDeclaration);
    }

    public void addBinaryFlowMethodBefore(Statement currentStatement, MethodDeclaration methodDeclaration) {
        ++this.m_modificationCount;
        List methods = this.m_binaryFlowMethodsBefore.get(currentStatement);
        if (methods == null) {
            methods = Lists.newArrayList();
            this.m_binaryFlowMethodsBefore.put((ASTNode)currentStatement, methods);
        }
        if (!methods.contains(methodDeclaration)) {
            methods.add(methodDeclaration);
        }
    }

    public void addBinaryFlowMethodAfter(MethodDeclaration methodDeclaration) {
        ++this.m_modificationCount;
        Statement currentStatement = this.getCurrentStatement();
        List methods = this.m_binaryFlowMethodsAfter.get(currentStatement);
        if (methods == null) {
            methods = Lists.newArrayList();
            this.m_binaryFlowMethodsAfter.put((ASTNode)currentStatement, methods);
        }
        if (!methods.contains(methodDeclaration)) {
            methods.add(methodDeclaration);
        }
    }

    public void addBinaryFlowMethodAfter(Statement currentStatement, MethodDeclaration methodDeclaration) {
        ++this.m_modificationCount;
        List methods = this.m_binaryFlowMethodsAfter.get(currentStatement);
        if (methods == null) {
            methods = Lists.newArrayList();
            this.m_binaryFlowMethodsAfter.put((ASTNode)currentStatement, methods);
        }
        if (!methods.contains(methodDeclaration)) {
            methods.add(methodDeclaration);
        }
    }

    public List<MethodDeclaration> getBinaryFlowMethodsBefore(Statement statement) {
        return this.m_binaryFlowMethodsBefore.get(statement);
    }

    public List<MethodDeclaration> getBinaryFlowMethodsAfter(Statement statement) {
        return this.m_binaryFlowMethodsAfter.get(statement);
    }
}

