/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.gson;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.gson.ParameterizedTypeImpl;

public class MultimapTypeAdapter
implements JsonSerializer<Multimap>,
JsonDeserializer<Multimap> {
    public JsonElement serialize(Multimap src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src.asMap(), this.createMapType(typeOfSrc));
    }

    public Multimap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        HashMultimap multimap = HashMultimap.create();
        Map map = (Map)context.deserialize(json, this.createMapType(typeOfT));
        for (Object key : map.keySet()) {
            Collection values = (Collection)map.get(key);
            multimap.putAll(key, (Iterable)values);
        }
        return multimap;
    }

    private Type createMapType(Type multimapType) {
        ParameterizedType paramType = Checks.ensureIsInstanceOf(multimapType, ParameterizedType.class);
        Type[] typeArguments = paramType.getActualTypeArguments();
        Checks.ensureEquals(2, typeArguments.length, "Type must contain exactly 2 type arguments.");
        ParameterizedTypeImpl valueType = new ParameterizedTypeImpl((Type)((Object)Collection.class), null, typeArguments[1]);
        ParameterizedTypeImpl mapType = new ParameterizedTypeImpl((Type)((Object)Map.class), null, typeArguments[0], valueType);
        return mapType;
    }
}

