/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.archive;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.archive.JarIdExtractor;
import org.eclipse.recommenders.utils.parser.OsgiVersionParser;

public class OsgiManifestJarIdExtractor
extends JarIdExtractor {
    private static final Attributes.Name BUNDLE_NAME = new Attributes.Name("Bundle-SymbolicName");
    private static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private final OsgiVersionParser parser = new OsgiVersionParser();

    @Override
    public void extract(JarFile jarFile) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            this.setName(attributes.getValue(BUNDLE_NAME));
            String version = attributes.getValue(BUNDLE_VERSION);
            if (version != null) {
                this.setVersion(this.parser.parse(version));
            }
        }
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            name = StringUtils.substringBefore((String)name, (String)";");
            name = name.trim();
        }
        super.setName(name);
    }
}

