/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.archive;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.recommenders.utils.Fingerprints;
import org.eclipse.recommenders.utils.GenericEnumerationUtils;
import org.eclipse.recommenders.utils.archive.ClassId;
import org.eclipse.recommenders.utils.archive.IExtractor;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class ClassIdExtractor
implements IExtractor {
    private final Collection<ClassId> types = new LinkedList<ClassId>();

    @Override
    public void extract(JarFile jarFile) throws Exception {
        for (ZipEntry zipEntry : GenericEnumerationUtils.iterable(jarFile.entries())) {
            if (!this.isClassFile(zipEntry.getName())) continue;
            this.extract(zipEntry.getName(), jarFile.getInputStream(zipEntry));
        }
    }

    private void extract(String filename, InputStream inputStream) throws Exception {
        ClassId type = new ClassId();
        type.typeName = this.getTypeName(filename);
        type.fingerprint = Fingerprints.sha1(inputStream);
        this.types.add(type);
    }

    private boolean isClassFile(String filename) {
        return filename.endsWith(".class");
    }

    private VmTypeName getTypeName(String filename) {
        return VmTypeName.get("L" + filename.substring(0, filename.length() - ".class".length()));
    }

    public Collection<ClassId> getClassIds() {
        return this.types;
    }
}

