/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3.LifecycleMappingMetadataSourceXpp3Writer;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.PropertyPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleMappingPropertyPage
extends PropertyPage {
    boolean showPhases = false;
    boolean showIgnoredExecutions = true;
    TreeViewer mappingsTreeViewer;
    IMavenProjectFacade facade;
    Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mappings;
    Map<String, List<MojoExecutionKey>> phases;

    public LifecycleMappingPropertyPage() {
        this.setMessage(Messages.LifecycleMappingPropertyPage_pageMessage);
        this.noDefaultAndApplyButton();
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginWidth = 0;
        gl_container.marginHeight = 0;
        container.setLayout((Layout)gl_container);
        this.mappingsTreeViewer = new TreeViewer(container, 2048);
        Tree tree = this.mappingsTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.mappingsTreeViewer, 0);
        TreeColumn trclmnGoal = treeViewerColumn.getColumn();
        trclmnGoal.setWidth(100);
        trclmnGoal.setText(Messages.LifecycleMappingPropertyPage_pluginExecution);
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.mappingsTreeViewer, 0);
        TreeColumn trclmnNewColumn = treeViewerColumn_1.getColumn();
        trclmnNewColumn.setWidth(100);
        trclmnNewColumn.setText(Messages.LifecycleMappingPropertyPage_mapping);
        this.mappingsTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element) != null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                Set<Object> executions;
                if (LifecycleMappingPropertyPage.this.showPhases) {
                    return LifecycleMappingPropertyPage.this.phases.keySet().toArray();
                }
                if (LifecycleMappingPropertyPage.this.showIgnoredExecutions) {
                    executions = LifecycleMappingPropertyPage.this.mappings.keySet();
                } else {
                    executions = new LinkedHashSet();
                    for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : LifecycleMappingPropertyPage.this.mappings.entrySet()) {
                        if (LifecycleMappingPropertyPage.this.isIgnoreMapping(entry.getKey(), entry.getValue())) continue;
                        executions.add(entry.getKey());
                    }
                }
                return executions.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                List<MojoExecutionKey> executions = LifecycleMappingPropertyPage.this.phases.get(parentElement);
                if (executions == null || executions.isEmpty()) {
                    return null;
                }
                if (LifecycleMappingPropertyPage.this.showIgnoredExecutions) {
                    return executions.toArray();
                }
                executions = new ArrayList<MojoExecutionKey>(executions);
                Iterator<MojoExecutionKey> iter = executions.iterator();
                while (iter.hasNext()) {
                    MojoExecutionKey execution = iter.next();
                    if (!LifecycleMappingPropertyPage.this.isIgnoreMapping(execution, LifecycleMappingPropertyPage.this.mappings.get(execution))) continue;
                    iter.remove();
                }
                return !executions.isEmpty() ? executions.toArray() : null;
            }
        });
        this.mappingsTreeViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0 && element instanceof MojoExecutionKey) {
                    return LifecycleMappingPropertyPage.this.isErrorMapping((MojoExecutionKey)element) ? MavenImages.IMG_ERROR : MavenImages.IMG_PASSED;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof MojoExecutionKey) {
                    MojoExecutionKey execution = (MojoExecutionKey)element;
                    switch (columnIndex) {
                        case 0: {
                            return LifecycleMappingPropertyPage.this.toString(execution);
                        }
                        case 1: {
                            return LifecycleMappingPropertyPage.this.toString(execution, LifecycleMappingPropertyPage.this.mappings.get(execution));
                        }
                    }
                }
                return columnIndex == 0 ? element.toString() : null;
            }
        });
        Menu menu = new Menu((Control)tree);
        tree.setMenu(menu);
        final MenuItem mntmShowPhases = new MenuItem(menu, 32);
        mntmShowPhases.setSelection(this.showPhases);
        mntmShowPhases.setText(Messages.LifecycleMappingPropertyPage_showLIfecyclePhases);
        final MenuItem mntmShowIgnoredExecutions = new MenuItem(menu, 32);
        mntmShowIgnoredExecutions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LifecycleMappingPropertyPage.this.showIgnoredExecutions = mntmShowIgnoredExecutions.getSelection();
                LifecycleMappingPropertyPage.this.updateMappingsTreeViewer();
            }
        });
        mntmShowIgnoredExecutions.setSelection(this.showIgnoredExecutions);
        mntmShowIgnoredExecutions.setText(Messages.LifecycleMappingPropertyPage_mntmShowIgnoredExecutions_text);
        new MenuItem(menu, 2);
        final MenuItem mntmExpandAll = new MenuItem(menu, 0);
        mntmExpandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LifecycleMappingPropertyPage.this.mappingsTreeViewer.expandAll();
            }
        });
        mntmExpandAll.setEnabled(this.showPhases);
        mntmExpandAll.setText(Messages.LifecycleMappingPropertyPage_mntmExpandAll_text);
        final MenuItem mntmCollapseAll = new MenuItem(menu, 0);
        mntmCollapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LifecycleMappingPropertyPage.this.mappingsTreeViewer.collapseAll();
            }
        });
        mntmCollapseAll.setEnabled(this.showPhases);
        mntmCollapseAll.setText(Messages.LifecycleMappingPropertyPage_mntmCollapseAll_text);
        mntmShowPhases.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LifecycleMappingPropertyPage.this.showPhases = mntmShowPhases.getSelection();
                mntmExpandAll.setEnabled(LifecycleMappingPropertyPage.this.showPhases);
                mntmCollapseAll.setEnabled(LifecycleMappingPropertyPage.this.showPhases);
                LifecycleMappingPropertyPage.this.updateMappingsTreeViewer();
            }
        });
        Composite actionsComposite = new Composite(container, 0);
        actionsComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        actionsComposite.setLayout((Layout)new RowLayout(256));
        Button btnCopyToClipboard = new Button(actionsComposite, 0);
        btnCopyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LifecycleMappingPropertyPage.this.copyToClipboard();
            }
        });
        btnCopyToClipboard.setText(Messages.LifecycleMappingPropertyPage_copyToClipboard);
        this.mappingsTreeViewer.setInput((Object)this.facade);
        this.updateMappingsTreeViewer();
        return container;
    }

    void copyToClipboard() {
        if (this.facade == null || this.mappings == null) {
            return;
        }
        LifecycleMappingMetadata meta = new LifecycleMappingMetadata();
        for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : this.mappings.entrySet()) {
            List<IPluginExecutionMetadata> mappings = entry.getValue();
            if (mappings != null && !mappings.isEmpty()) {
                for (IPluginExecutionMetadata mapping : mappings) {
                    meta.addPluginExecution((PluginExecutionMetadata)mapping);
                }
                continue;
            }
            MojoExecutionKey execution = entry.getKey();
            PluginExecutionFilter filter = new PluginExecutionFilter(execution.getGroupId(), execution.getArtifactId(), execution.getVersion(), execution.getGoal());
            PluginExecutionMetadata mapping = new PluginExecutionMetadata();
            mapping.setFilter(filter);
            Xpp3Dom actionDom = LifecycleMappingFactory.isInterestingPhase((String)entry.getKey().getLifecyclePhase()) ? new Xpp3Dom(PluginExecutionAction.error.toString()) : new Xpp3Dom(PluginExecutionAction.ignore.toString());
            mapping.setActionDom((Object)actionDom);
            meta.addPluginExecution(mapping);
        }
        LifecycleMappingMetadataSource xml = new LifecycleMappingMetadataSource();
        xml.addLifecycleMapping(meta);
        StringWriter buf = new StringWriter();
        try {
            new LifecycleMappingMetadataSourceXpp3Writer().write((Writer)buf, xml);
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            Object[] data = new Object[]{buf.toString()};
            Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
            clipboard.setContents(data, dataTypes);
            clipboard.dispose();
        }
        catch (IOException iOException) {}
    }

    boolean isErrorMapping(MojoExecutionKey execution) {
        List<IPluginExecutionMetadata> mappings = this.mappings.get(execution);
        if (mappings == null || mappings.isEmpty()) {
            return LifecycleMappingFactory.isInterestingPhase((String)execution.getLifecyclePhase());
        }
        for (IPluginExecutionMetadata mapping : mappings) {
            if (PluginExecutionAction.error != mapping.getAction()) continue;
            return true;
        }
        return false;
    }

    void updateMappingsTreeViewer() {
        this.mappingsTreeViewer.refresh();
        if (this.showPhases) {
            this.mappingsTreeViewer.collapseAll();
            for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : this.mappings.entrySet()) {
                boolean expand = false;
                if (this.isErrorMapping(entry.getKey())) {
                    expand = true;
                } else {
                    boolean bl = expand = !this.isIgnoreMapping(entry.getKey(), entry.getValue());
                }
                if (!expand) continue;
                this.mappingsTreeViewer.expandToLevel((Object)entry.getKey().getLifecyclePhase(), -1);
            }
        }
        TreeColumn[] treeColumnArray = this.mappingsTreeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    boolean isIgnoreMapping(MojoExecutionKey execution, List<IPluginExecutionMetadata> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            return !LifecycleMappingFactory.isInterestingPhase((String)execution.getLifecyclePhase());
        }
        for (IPluginExecutionMetadata mapping : mappings) {
            if (PluginExecutionAction.ignore == mapping.getAction()) continue;
            return false;
        }
        return true;
    }

    String toString(MojoExecutionKey execution, List<IPluginExecutionMetadata> mappings) {
        StringBuilder sb = new StringBuilder();
        if (mappings != null && !mappings.isEmpty()) {
            for (IPluginExecutionMetadata mapping : mappings) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(mapping.getAction().toString());
            }
        } else if (LifecycleMappingFactory.isInterestingPhase((String)execution.getLifecyclePhase())) {
            sb.append(PluginExecutionAction.error.toString());
        } else {
            sb.append(PluginExecutionAction.ignore.toString());
        }
        return sb.toString();
    }

    String toString(MojoExecutionKey execution) {
        StringBuilder sb = new StringBuilder();
        String artifactId = execution.getArtifactId();
        if (artifactId.endsWith("-maven-plugin")) {
            artifactId = artifactId.substring(0, artifactId.length() - "-maven-plugin".length());
        } else if (artifactId.startsWith("maven-") && artifactId.endsWith("-plugin")) {
            artifactId = artifactId.substring("maven-".length(), artifactId.length() - "-plugin".length());
        }
        sb.append(artifactId).append(':').append(execution.getGoal());
        int count = 0;
        for (MojoExecutionKey other : this.mappings.keySet()) {
            if (!LifecycleMappingPropertyPage.eq(execution.getGroupId(), other.getGroupId()) || !LifecycleMappingPropertyPage.eq(execution.getArtifactId(), other.getArtifactId()) || !LifecycleMappingPropertyPage.eq(execution.getGoal(), other.getGoal())) continue;
            ++count;
        }
        if (count > 1) {
            sb.append(" (").append(execution.getExecutionId()).append(")");
        }
        return sb.toString();
    }

    static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        this.facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
        this.mappings = this.facade.getMojoExecutionMapping();
        this.phases = new LinkedHashMap<String, List<MojoExecutionKey>>();
        for (MojoExecutionKey execution : this.mappings.keySet()) {
            List<MojoExecutionKey> executions = this.phases.get(execution.getLifecyclePhase());
            if (executions == null) {
                executions = new ArrayList<MojoExecutionKey>();
                this.phases.put(execution.getLifecyclePhase(), executions);
            }
            executions.add(execution);
        }
    }
}

