/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.lifecyclemapping;

import java.util.Collection;
import java.util.Collections;
import org.apache.maven.project.MavenProject;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ProjectLifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.lifecyclemapping.ILifecycleMappingLabelProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoExecutionMappingLabelProvider
implements ILifecycleMappingLabelProvider {
    private final MojoExecutionMappingConfiguration element;
    private final ProjectLifecycleMappingConfiguration prjconf;

    public MojoExecutionMappingLabelProvider(ProjectLifecycleMappingConfiguration prjconf, MojoExecutionMappingConfiguration element) {
        this.element = element;
        this.prjconf = prjconf;
    }

    @Override
    public String getMavenText() {
        MojoExecutionKey execution = this.element.getExecution();
        if ("default".equals(execution.getExecutionId())) {
            return NLS.bind((String)"{0}", (Object)this.prjconf.getRelpath());
        }
        return NLS.bind((String)"Execution {0}, in {1}", (Object)execution.getExecutionId(), (Object)this.prjconf.getRelpath());
    }

    @Override
    public boolean isError(LifecycleMappingConfiguration mappingConfiguration) {
        ILifecycleMappingRequirement requirement = this.element.getLifecycleMappingRequirement();
        return LifecycleMappingFactory.isInterestingPhase((String)this.element.getMojoExecutionKey().getLifecyclePhase()) && !mappingConfiguration.isRequirementSatisfied(requirement, true);
    }

    @Override
    public ILifecycleMappingRequirement getKey() {
        return this.element.getLifecycleMappingRequirement();
    }

    @Override
    public Collection<MavenProject> getProjects() {
        return Collections.singleton(this.prjconf.getMavenProject());
    }
}

