/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.m2e.refactoring.internal.SaveDirtyFilesDialog;
import org.eclipse.m2e.refactoring.rename.MavenRenameWizard;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameArtifactAction
extends ActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(RenameArtifactAction.class);

    public void init(IAction action) {
        super.init(action);
    }

    public void run(IAction action) {
        this.doRun(action);
    }

    public void runWithEvent(IAction action, Event event) {
        this.doRun(action);
    }

    public void doRun(IAction action) {
        IProject project;
        IFile file;
        Object element = ((IStructuredSelection)((ObjectPluginAction)action).getSelection()).getFirstElement();
        if (element instanceof IFile) {
            this.rename((IFile)element);
        } else if (element instanceof IProject && (file = (project = (IProject)element).getFile("pom.xml")) != null) {
            this.rename(file);
        }
    }

    private void rename(IFile file) {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean rc = SaveDirtyFilesDialog.saveDirtyFiles("pom.xml");
            if (!rc) {
                return;
            }
            MavenRenameWizard wizard = new MavenRenameWizard(file);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            String titleForFailedChecks = "";
            op.run(shell, titleForFailedChecks);
        }
        catch (Exception e) {
            log.error("Unable to rename " + file, (Throwable)e);
        }
    }
}

