/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentEditContext;

public class FileDocumentEditContext
extends AbstractDocumentEditContext {
    private final IFile m_file;
    private final ITextFileBuffer m_buffer;

    public FileDocumentEditContext(IFile file) throws Exception {
        this.m_file = file;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(this.m_file.getFullPath(), null);
        this.m_buffer = manager.getTextFileBuffer(file.getFullPath());
        this.parse(this.m_buffer.getDocument());
        String charset = this.m_file.getCharset();
        this.getRoot().getModel().setCharset(charset);
    }

    public final void commit() {
        ExecutionUtils.runRethrowUI(new RunnableEx(){

            public void run() throws Exception {
                FileDocumentEditContext.this.commit_super();
                FileDocumentEditContext.this.m_buffer.commit(null, false);
            }
        });
    }

    private void commit_super() {
        super.commit();
    }

    public final void disconnect() throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.disconnect(this.m_file.getFullPath(), null);
        super.disconnect();
    }
}

