/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath;

import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.IClasspathImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.JarImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.SrcImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageRoot;

public final class ClasspathImageRoot
implements IImageRoot {
    private final IJavaProject m_project;
    private final IImageContainer[] m_containers;

    public ClasspathImageRoot(String id, IJavaProject project) {
        this.m_project = project;
        ArrayList<IImageContainer> containers = new ArrayList<IImageContainer>();
        try {
            IPackageFragmentRoot[] roots = this.m_project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                try {
                    if (root.isArchive()) {
                        JarImageContainer jarContainer = new JarImageContainer(id, root);
                        if (!jarContainer.isEmpty()) {
                            containers.add(jarContainer);
                        }
                    } else {
                        SrcImageContainer srcContainer = new SrcImageContainer(id, root);
                        if (!srcContainer.isEmpty()) {
                            containers.add(srcContainer);
                        }
                    }
                }
                catch (Throwable throwable) {}
                ++i;
            }
        }
        catch (Throwable throwable) {}
        this.m_containers = containers.toArray(new IImageContainer[containers.size()]);
    }

    public void dispose() {
        int i = 0;
        while (i < this.m_containers.length) {
            IClasspathImageContainer container = (IClasspathImageContainer)((Object)this.m_containers[i]);
            container.dispose();
            ++i;
        }
    }

    public IImageElement[] elements() {
        return this.m_containers;
    }

    public Object[] getSelectionPath(Object data) {
        if (data instanceof String) {
            String path = (String)data;
            if (!path.startsWith("/")) {
                return null;
            }
            path = path.substring(1);
            Path pathObject = new Path(path);
            String packageName = pathObject.removeLastSegments(1).toPortableString().replace('/', '.');
            String resourceName = pathObject.lastSegment();
            int i = 0;
            while (i < this.m_containers.length) {
                IImageContainer rootContainer = this.m_containers[i];
                IImageElement[] packageContainers = rootContainer.elements();
                int j = 0;
                while (j < packageContainers.length) {
                    IImageContainer packageContainer = (IImageContainer)packageContainers[j];
                    if (packageContainer.getName().equals(packageName)) {
                        IImageElement[] elements = packageContainer.elements();
                        int k = 0;
                        while (k < elements.length) {
                            IImageElement element = elements[k];
                            if (element.getName().equals(resourceName)) {
                                return new Object[]{rootContainer, packageContainer, element};
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }
}

