/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.parser;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.core.model.IWrapper;
import org.eclipse.wb.core.model.IWrapperInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.creation.CastedSuperInvocationCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedFieldCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaInfoResolver {
    private final EditorState m_editorState;
    private final CompilationUnit m_unit;
    private final List<JavaInfo> m_components = Lists.newArrayList();
    private boolean m_thisJavaInfoReady = false;
    private JavaInfo m_thisJavaInfo = null;
    private JavaInfo m_rootJavaInfo = null;
    private static final String KEY_COMPONENTS_STAMP = "JavaInfoResolver.components.stamp";

    public JavaInfoResolver(AstEditor editor) {
        this.m_editorState = EditorState.get(editor);
        this.m_editorState.setJavaInfoResolver(this);
        this.m_unit = editor.getAstUnit();
    }

    public void setRootJavaInfo(JavaInfo rootJavaInfo) {
        this.m_rootJavaInfo = rootJavaInfo;
    }

    public void addJavaInfo(JavaInfo javaInfo, Expression creation) {
        this.m_components.add(javaInfo);
        if (creation != null) {
            this.bind(javaInfo, creation);
        }
    }

    public void bind(JavaInfo javaInfo, Expression expression) {
        ExpressionValue value = ExecutionFlowUtils2.ensurePermanentValue(expression);
        value.setModel(javaInfo);
    }

    public static JavaInfo getJavaInfo(JavaInfo someJavaInfo, Expression expression) {
        Assert.isNotNull(someJavaInfo);
        EditorState editorState = EditorState.get(someJavaInfo.getEditor());
        JavaInfoResolver resolver = editorState.getJavaInfoResolver();
        return resolver.getJavaInfo(expression);
    }

    public JavaInfo getJavaInfo(Expression expression) {
        try {
            return this.getJavaInfo0(expression);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    private JavaInfo getJavaInfo0(Expression expression) throws Exception {
        String fieldName;
        if (expression instanceof NullLiteral || expression instanceof BooleanLiteral || expression instanceof NumberLiteral || expression instanceof StringLiteral || expression instanceof TypeLiteral || expression instanceof Assignment || expression instanceof ArrayCreation || expression instanceof ArrayInitializer) {
            return null;
        }
        if (expression == null || expression instanceof ThisExpression) {
            if (!this.m_thisJavaInfoReady) {
                this.m_thisJavaInfoReady = true;
                for (JavaInfo component : this.getComponents()) {
                    if (!(component.getCreationSupport() instanceof ThisCreationSupport)) continue;
                    this.m_thisJavaInfo = component;
                    break;
                }
            }
            if (this.m_thisJavaInfo != null) {
                this.m_thisJavaInfo.addRelatedNode((ASTNode)expression);
            }
            return this.m_thisJavaInfo;
        }
        ExecutionFlowDescription flowDescription = this.m_editorState.getFlowDescription();
        ExpressionValue value = ExecutionFlowUtils2.getValue(flowDescription, expression);
        if (value != null) {
            JavaInfo javaInfo = (JavaInfo)value.getModel();
            if (javaInfo != null) {
                boolean expressionPartOfCasted;
                boolean bl = expressionPartOfCasted = javaInfo.getCreationSupport() instanceof CastedSuperInvocationCreationSupport && expression.getLocationInParent() == CastExpression.EXPRESSION_PROPERTY;
                if (!expressionPartOfCasted) {
                    javaInfo.addRelatedNode((ASTNode)expression);
                }
                return javaInfo;
            }
            Expression newExpression = value.getExpression();
            if (newExpression instanceof ThisExpression && newExpression != expression) {
                return this.getJavaInfo0(newExpression);
            }
        }
        if (AstNodeUtils.isSuccessorOf(expression, "org.eclipse.ui.forms.widgets.FormToolkit")) {
            for (JavaInfo component : this.getComponents()) {
                if (!(component instanceof InstanceFactoryInfo) || !component.getCreationSupport().isJavaInfo((ASTNode)expression)) continue;
                ExecutionFlowUtils2.ensurePermanentValue(expression).setModel(component);
                component.addRelatedNode((ASTNode)expression);
                return component;
            }
        }
        if (expression instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)expression;
            String invName = invocation.getName().getIdentifier();
            if (invName.equals("get") && AstNodeUtils.isSuccessorOf((Expression)invocation, "com.google.gwt.user.client.ui.RootPanel")) {
                for (JavaInfo component : this.getComponents()) {
                    if (!component.getCreationSupport().isJavaInfo((ASTNode)invocation)) continue;
                    ExecutionFlowUtils2.ensurePermanentValue(expression).setModel(component);
                    component.addRelatedNode((ASTNode)expression);
                    return component;
                }
            }
            if (invName.startsWith("get")) {
                JavaInfo expressionJavaInfo = this.getJavaInfo(invocation.getExpression());
                JavaInfo result = this.getExposedJavaInfo(expressionJavaInfo, invocation);
                if (result != null) {
                    return result;
                }
                if (expressionJavaInfo instanceof IWrapperInfo) {
                    IWrapperInfo wrapperInfo = (IWrapperInfo)((Object)expressionJavaInfo);
                    IWrapper wrapper = wrapperInfo.getWrapper();
                    JavaInfo javaInfo = wrapper.getWrappedInfo();
                    if (wrapper.isWrappedInfo((ASTNode)invocation)) {
                        ExecutionFlowUtils2.ensurePermanentValue(expression).setModel(javaInfo);
                        javaInfo.addRelatedNode((ASTNode)expression);
                        return javaInfo;
                    }
                }
            }
            return null;
        }
        if (expression instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)expression;
            JavaInfo thisJavaInfo = this.getJavaInfo(null);
            fieldName = simpleName.getIdentifier();
            return this.getExposedJavaInfo(thisJavaInfo, expression, fieldName);
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            JavaInfo hostJavaInfo = this.getJavaInfo((Expression)qualifiedName.getQualifier());
            fieldName = qualifiedName.getName().getIdentifier();
            return this.getExposedJavaInfo(hostJavaInfo, expression, fieldName);
        }
        return null;
    }

    private JavaInfo getExposedJavaInfo(JavaInfo parent, MethodInvocation invocation) {
        JavaInfo result;
        CreationSupport childCreationSupport;
        if (parent == null) {
            return null;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof IImplicitCreationSupport) || !childCreationSupport.isJavaInfo((ASTNode)invocation)) continue;
            ExecutionFlowUtils2.ensurePermanentValue((Expression)invocation).setModel(child);
            child.addRelatedNode((ASTNode)invocation);
            return child;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof IImplicitCreationSupport) || (result = this.getExposedJavaInfo(child, invocation)) == null) continue;
            return result;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof WrapperMethodControlCreationSupport) || (result = this.getExposedJavaInfo(child, invocation)) == null) continue;
            return result;
        }
        return null;
    }

    private JavaInfo getExposedJavaInfo(JavaInfo parent, Expression expression, String fieldName) {
        if (parent == null) {
            return null;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            ExposedFieldCreationSupport cs;
            if (!(child.getCreationSupport() instanceof ExposedFieldCreationSupport) || !(cs = (ExposedFieldCreationSupport)child.getCreationSupport()).getField().getName().equals(fieldName)) continue;
            child.addRelatedNode((ASTNode)expression);
            return child;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            JavaInfo result;
            CreationSupport childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof IImplicitCreationSupport) || (result = this.getExposedJavaInfo(child, expression, fieldName)) == null) continue;
            return result;
        }
        return null;
    }

    public List<JavaInfo> getComponents() throws Exception {
        if (this.m_rootJavaInfo == null) {
            return this.m_components;
        }
        Long stampComponents = (Long)this.m_unit.getProperty(KEY_COMPONENTS_STAMP);
        long stampAST = this.m_unit.getAST().modificationCount();
        if (stampComponents == null || stampAST != stampComponents) {
            this.m_components.clear();
            this.m_rootJavaInfo.accept0(new ObjectInfoVisitor(){

                public void endVisit(ObjectInfo objectInfo) throws Exception {
                    if (objectInfo instanceof JavaInfo) {
                        JavaInfo javaInfo = (JavaInfo)objectInfo;
                        if (!this.isExplicitJavaInfo(javaInfo)) {
                            return;
                        }
                        JavaInfoResolver.this.m_components.add(javaInfo);
                    }
                }

                private boolean isExplicitJavaInfo(JavaInfo javaInfo) {
                    CreationSupport creationSupport = javaInfo.getCreationSupport();
                    return !(creationSupport instanceof IImplicitCreationSupport);
                }
            });
            this.m_unit.setProperty(KEY_COMPONENTS_STAMP, (Object)stampAST);
        }
        return this.m_components;
    }
}

