/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.VariableProperty;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.state.EditorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedVariableSupport
extends VariableSupport {
    protected Expression m_variable;
    protected VariableDeclaration m_declaration;
    private final VariableProperty m_variableProperty = new VariableProperty(this);

    public AbstractNamedVariableSupport(JavaInfo javaInfo, Expression variable) {
        super(javaInfo);
        this.m_variable = variable;
        this.rememberDeclaration();
    }

    @Override
    public final boolean hasName() {
        return this.m_variable != null;
    }

    @Override
    public final String getName() {
        if (this.m_variable == null) {
            return "no-variable-yet";
        }
        return AstNodeUtils.getVariableName((ASTNode)this.m_variable);
    }

    @Override
    public String getTitle() throws Exception {
        return this.getName();
    }

    @Override
    public String getComponentName() {
        return this.getName();
    }

    public final void setNameBase(String nameBase) throws Exception {
        int position = this.m_variable.getStartPosition();
        String newName = this.m_javaInfo.getEditor().getUniqueVariableName(position, nameBase, null);
        this.setName(newName);
    }

    @Override
    public final void addProperties(List<Property> properties) {
        properties.add(this.m_variableProperty);
    }

    @Override
    public final String getAccessExpression(NodeTarget target) throws Exception {
        return String.valueOf(this.getReferenceExpression(target)) + ".";
    }

    protected final ExecutionFlowDescription getFlowDescription() {
        AstEditor editor = this.m_javaInfo.getEditor();
        EditorState state = EditorState.get(editor);
        return state.getFlowDescription();
    }

    protected final TypeDeclaration getTypeDeclaration() {
        return this.getFlowDescription().geTypeDeclaration();
    }

    protected final boolean isStaticContext() {
        int position = this.m_javaInfo.getCreationSupport().getNode().getStartPosition();
        return this.isStaticContext(position);
    }

    protected final boolean isStaticContext(int position) {
        ASTNode enclosingNode = this.m_javaInfo.getEditor().getEnclosingNode(position);
        TypeDeclaration type = this.getTypeDeclaration();
        MethodDeclaration method = AstNodeUtils.getEnclosingMethod(type, enclosingNode);
        return AstNodeUtils.isStatic((BodyDeclaration)method);
    }

    protected final void rememberDeclaration() {
        ExecutionFlowDescription flowDescription;
        if (this.m_variable != null && (flowDescription = this.getFlowDescription()) != null) {
            this.m_declaration = ExecutionFlowUtils.getDeclaration(flowDescription, (ASTNode)this.m_variable);
        }
    }

    protected final List<Expression> getReferences() {
        return ExecutionFlowUtils.getReferences(this.getFlowDescription(), (ASTNode)this.m_variable);
    }

    protected final List<Expression> getComponentReferences() {
        List componentReferences = Lists.newArrayList();
        for (Expression reference : this.getReferences()) {
            if (!this.m_javaInfo.isRepresentedBy((ASTNode)reference)) continue;
            componentReferences.add(reference);
        }
        return componentReferences;
    }

    public static String validateVariables(Map<AbstractNamedVariableSupport, String> variablesNames, Set<AbstractNamedVariableSupport> toLocalVariables, Set<AbstractNamedVariableSupport> toFieldVariables) {
        String name;
        AbstractNamedVariableSupport variable;
        for (String name2 : variablesNames.values()) {
            IStatus status = JavaConventions.validateIdentifier((String)name2);
            if (!status.matches(4)) continue;
            return status.getMessage();
        }
        Map declarationsNames = Maps.newHashMap();
        for (Map.Entry<AbstractNamedVariableSupport, String> entry : variablesNames.entrySet()) {
            variable = entry.getKey();
            name = entry.getValue();
            declarationsNames.put(variable.m_declaration, name);
        }
        for (Map.Entry<AbstractNamedVariableSupport, String> entry : variablesNames.entrySet()) {
            variable = entry.getKey();
            name = entry.getValue();
            CompilationUnit astUnit = variable.m_javaInfo.getEditor().getAstUnit();
            int position = variable.m_variable.getStartPosition();
            List<VariableDeclaration> declarations = AstNodeUtils.getVariableDeclarationsVisibleAt((ASTNode)astUnit, position);
            for (VariableDeclaration declaration : declarations) {
                if (!AbstractNamedVariableSupport.getDeclarationName(declaration, declarationsNames).equals(name)) continue;
                return MessageFormat.format("Variable \"{0}\" is already visible at this position.", name);
            }
            declarations = AstNodeUtils.getVariableDeclarationsAfter((ASTNode)astUnit, position);
            for (VariableDeclaration declaration : declarations) {
                if (!AbstractNamedVariableSupport.getDeclarationName(declaration, declarationsNames).equals(name)) continue;
                return MessageFormat.format("Variable \"{0}\" conflicts with other variable declared after it.", name);
            }
        }
        return null;
    }

    private static String getDeclarationName(VariableDeclaration declaration, Map<VariableDeclaration, String> declarationsNames) {
        String newName = declarationsNames.get(declaration);
        return newName != null ? newName : declaration.getName().getIdentifier();
    }

    public final String validateName(String name) throws Exception {
        IStatus status = JavaConventions.validateIdentifier((String)name);
        if (status.matches(4)) {
            return status.getMessage();
        }
        CompilationUnit astUnit = this.m_javaInfo.getEditor().getAstUnit();
        int position = this.m_variable.getStartPosition();
        List<VariableDeclaration> declarations = AstNodeUtils.getVariableDeclarationsVisibleAt((ASTNode)astUnit, position);
        for (VariableDeclaration declaration : declarations) {
            if (!declaration.getName().getIdentifier().equals(name)) continue;
            return MessageFormat.format("Variable \"{0}\" is already visible at this position.", name);
        }
        declarations = AstNodeUtils.getVariableDeclarationsAfter((ASTNode)astUnit, position);
        for (VariableDeclaration declaration : declarations) {
            if (!declaration.getName().getIdentifier().equals(name)) continue;
            return MessageFormat.format("Variable \"{0}\" conflicts with other variable declared after it.", name);
        }
        return null;
    }

    protected final void modifyName(String newIdentifier) throws Exception {
        for (Expression reference : this.getReferences()) {
            this.modifyVariableName(reference, newIdentifier);
        }
        this.m_javaInfo.getBroadcastJava().variable_setName(this);
    }

    protected final void modifyVariableName(Expression variable, String newIdentifier) throws Exception {
        SimpleName simpleName = AstNodeUtils.getVariableSimpleName((ASTNode)variable);
        this.m_javaInfo.getEditor().setIdentifier(simpleName, newIdentifier);
    }

    protected final void replaceComponentReferences(String newVariableName) throws Exception {
        for (Expression reference : this.getComponentReferences()) {
            this.modifyVariableName(reference, newVariableName);
        }
    }
}

