/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static String[] getTitles(Property ... properties) {
        String[] titles = new String[properties.length];
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            titles[i] = property.getTitle();
            ++i;
        }
        return titles;
    }

    public static List<String> getTitles(List<Property> properties) {
        List titles = Lists.newArrayList();
        for (Property property : properties) {
            titles.add(property.getTitle());
        }
        return titles;
    }

    public static String getText(final Property property) {
        return ExecutionUtils.runObjectIgnore(new RunnableObjectEx<String>(){

            @Override
            public String runObject() throws Exception {
                return (String)ReflectionUtils.invokeMethod2((Object)property.getEditor(), "getText", Property.class, property);
            }
        }, null);
    }

    public static Property getByTitle(Property[] properties, String title) {
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (title.equals(property.getTitle())) {
                return property;
            }
            ++n2;
        }
        return null;
    }

    public static Property getByTitle(List<Property> properties, String title) {
        for (Property property : properties) {
            if (!StringUtils.equals((String)title, (String)property.getTitle())) continue;
            return property;
        }
        return null;
    }

    public static Property getByPath(ObjectInfo object, String path) throws Exception {
        return PropertyUtils.getByPath(object.getProperties(), path);
    }

    public static Property getByPath(List<Property> properties, String path) throws Exception {
        Property[] propertiesArray = properties.toArray(new Property[properties.size()]);
        return PropertyUtils.getByPath(propertiesArray, path);
    }

    public static Property getByPath(Property[] properties, String path) throws Exception {
        Property property = null;
        String[] stringArray = StringUtils.split((String)path, (char)'/');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pathElement = stringArray[n2];
            property = PropertyUtils.getByTitle(properties, pathElement);
            properties = PropertyUtils.getChildren(property);
            ++n2;
        }
        return property;
    }

    public static Property[] getChildren(Property property) throws Exception {
        if (property != null && property.getEditor() instanceof IComplexPropertyEditor) {
            return ((IComplexPropertyEditor)((Object)property.getEditor())).getProperties(property);
        }
        return new Property[0];
    }

    public static List<Property> getProperties(JavaInfo javaInfo, Predicate<Property> predicate) throws Exception {
        Property[] properties = javaInfo.getProperties();
        List filteredProperties = Lists.newArrayList();
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (predicate.apply((Object)property)) {
                filteredProperties.add(property);
            }
            ++n2;
        }
        return filteredProperties;
    }

    public static List<Property> getProperties_excludeByParameter(JavaInfo javaInfo, String parameterName) throws Exception {
        Predicate<Property> predicate = PropertyUtils.getExcludeByTitlePredicate(javaInfo, parameterName);
        return PropertyUtils.getProperties(javaInfo, predicate);
    }

    public static void filterProperties(List<Property> properties, Predicate<Property> predicate) throws Exception {
        Iterator<Property> I = properties.iterator();
        while (I.hasNext()) {
            Property property = I.next();
            if (predicate.apply((Object)property)) continue;
            I.remove();
        }
    }

    public static Predicate<Property> getExcludeByTitlePredicate(JavaInfo javaInfo, String parameterName) {
        Predicate<Property> predicate = Predicates.alwaysTrue();
        String propertiesExcludeString = JavaInfoUtils.getParameter(javaInfo, parameterName);
        if (propertiesExcludeString != null) {
            String[] propertiesExclude = StringUtils.split((String)propertiesExcludeString);
            predicate = PropertyUtils.getExcludeByTitlePredicate(propertiesExclude);
        }
        return predicate;
    }

    public static Predicate<Property> getExcludeByTitlePredicate(final String ... excludeTitles) {
        return new Predicate<Property>(){

            public boolean apply(Property t) {
                return !ArrayUtils.contains((Object[])excludeTitles, (Object)t.getTitle());
            }
        };
    }

    public static Predicate<Property> getIncludeByTitlePredicate(final String ... includeTitles) {
        return new Predicate<Property>(){

            public boolean apply(Property t) {
                return ArrayUtils.contains((Object[])includeTitles, (Object)t.getTitle());
            }
        };
    }

    public static GenericPropertyImpl createGenericPropertyImpl(JavaInfo javaInfo, GenericPropertyDescription description) {
        GenericPropertyImpl property = new GenericPropertyImpl(javaInfo, description.getTitle(), description.getAccessorsArray(), description.getDefaultValue(), description.getConverter(), description.getEditor());
        property.setDescription(description);
        property.setCategory(description.getCategory());
        return property;
    }
}

