/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationUtils;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.MorphingTargetDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentPresentationHelper;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.SubtypesScope;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.ImageImageDescriptor;
import org.eclipse.wb.internal.core.utils.ui.MenuManagerEx;

public final class MorphingSupport {
    private final String m_toolkitClassName;
    private final JavaInfo m_component;
    private final AstEditor m_editor;

    public static void contribute(String toolkitClassName, JavaInfo component, IContributionManager manager) throws Exception {
        if (!(component.getVariableSupport() instanceof AbstractSimpleVariableSupport)) {
            return;
        }
        MenuManagerEx morphManager = new MenuManagerEx(ModelMessages.MorphingSupport_managerText);
        morphManager.setImage(DesignerPlugin.getImage("actions/morph/morph2.png"));
        manager.appendToGroup("org.eclipse.wb.popup.group.inheritance", (IContributionItem)morphManager);
        new MorphingSupport(toolkitClassName, component).contribute((IContributionManager)morphManager);
    }

    private MorphingSupport(String toolkitClassName, JavaInfo component) {
        this.m_toolkitClassName = toolkitClassName;
        this.m_component = component;
        this.m_editor = this.m_component.getEditor();
    }

    private void contribute(IContributionManager morphManager) throws Exception {
        for (MorphingTargetDescription target : this.m_component.getDescription().getMorphingTargets()) {
            morphManager.add((IAction)new MorphTargetAction(target));
        }
        morphManager.add((IContributionItem)new Separator());
        String baseClassName = this.m_component.getDescription().getComponentClass().getName();
        MorphSubclassAction action = new MorphSubclassAction(baseClassName);
        action.setImageDescriptor(DesignerPlugin.getImageDescriptor("actions/morph/subclass.gif"));
        action.setText(ModelMessages.MorphingSupport_subclassAction);
        morphManager.add((IAction)action);
        MorphSubclassAction action2 = new MorphSubclassAction(this.m_toolkitClassName);
        action2.setImageDescriptor(DesignerPlugin.getImageDescriptor("actions/morph/other.gif"));
        action2.setText(ModelMessages.MorphingSupport_otherAction);
        morphManager.add((IAction)action2);
    }

    public static void morph(String toolkitClassName, JavaInfo component, MorphingTargetDescription target) throws Exception {
        new MorphingSupport(toolkitClassName, component).morph(target);
    }

    private String validate(MorphingTargetDescription target) throws Exception {
        Set associationSignatures = Sets.newHashSet();
        for (JavaInfo child : this.m_component.getChildrenJava()) {
            if (!(child.getAssociation() instanceof InvocationChildAssociation)) continue;
            InvocationChildAssociation association = (InvocationChildAssociation)child.getAssociation();
            String signature = association.getDescription().getSignature();
            associationSignatures.add(signature);
        }
        Class<?> targetClass = target.getComponentClass();
        ComponentDescription targetDescription = ComponentDescriptionHelper.getDescription(this.m_editor, targetClass);
        for (String associationSignature : associationSignatures) {
            MethodDescription method = targetDescription.getMethod(associationSignature);
            if (method == null) {
                return MessageFormat.format(ModelMessages.MorphingSupport_validateNoAssociationMethod, associationSignature);
            }
            boolean hasChild = false;
            List<ParameterDescription> parameters = method.getParameters();
            for (ParameterDescription parameter : parameters) {
                hasChild |= parameter.isChild();
            }
            if (hasChild) continue;
            return String.valueOf(ModelMessages.MorphingSupport_validateAssociationMethod_1) + associationSignature + ModelMessages.MorphingSupport_validateAssociationMethod_2 + ModelMessages.MorphingSupport_validateAssociationMethod_3 + ModelMessages.MorphingSupport_validateAssociationMethod_4;
        }
        return null;
    }

    private void morph(MorphingTargetDescription target) throws Exception {
        if (this.m_component.getCreationSupport() instanceof ConstructorCreationSupport || this.m_component.getCreationSupport() instanceof StaticFactoryCreationSupport || this.m_component.getCreationSupport() instanceof InstanceFactoryCreationSupport) {
            ComponentDescription newDescription = ComponentDescriptionHelper.getDescription(this.m_editor, target.getComponentClass());
            ConstructorCreationSupport newCreationSupport = this.getTargetCreationSupport(target);
            JavaInfo newComponent = JavaInfoUtils.createJavaInfo(this.m_editor, newDescription, (CreationSupport)newCreationSupport);
            this.m_component.getBroadcastJava().replaceChildBefore(this.m_component.getParentJava(), this.m_component, newComponent);
            this.m_component.getParent().replaceChild(this.m_component, newComponent);
            for (ASTNode node : this.m_component.getRelatedNodes()) {
                QualifiedName fieldAccess;
                MethodInvocation invocation;
                String signature;
                if (node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY && newDescription.getMethod(signature = AstNodeUtils.getMethodSignature(invocation = (MethodInvocation)node.getParent())) == null) {
                    this.m_editor.removeEnclosingStatement((ASTNode)invocation);
                    continue;
                }
                if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY && (fieldAccess = (QualifiedName)node.getParent()).getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                    String fieldName = fieldAccess.getName().getIdentifier();
                    if (ReflectionUtils.getFieldByName(target.getComponentClass(), fieldName) == null) {
                        this.m_editor.removeEnclosingStatement(node);
                        continue;
                    }
                }
                newComponent.addRelatedNode(node);
            }
            for (JavaInfo javaChild : this.m_component.getChildrenJava()) {
                newComponent.addChild(javaChild);
            }
            AbstractSimpleVariableSupport variable = (AbstractSimpleVariableSupport)this.m_component.getVariableSupport();
            variable.setType(target.getComponentClass().getName());
            this.m_component.getVariableSupport().moveTo(newComponent);
            CreationSupport oldCreationSupport = this.m_component.getCreationSupport();
            Expression oldCreationExpression = (Expression)oldCreationSupport.getNode();
            StatementTarget statementTarget = new StatementTarget(AstNodeUtils.getEnclosingStatement((ASTNode)oldCreationExpression), true);
            String source = ((CreationSupport)newCreationSupport).add_getSource(null);
            source = AssociationUtils.replaceTemplates(newComponent, source, statementTarget);
            Expression newCreationExpression = this.m_editor.replaceExpression(oldCreationExpression, source);
            ((CreationSupport)newCreationSupport).add_setSourceExpression(newCreationExpression);
            newComponent.addRelatedNode((ASTNode)newCreationExpression);
            Association oldAssociation = this.m_component.getAssociation();
            Association newAssociation = oldAssociation.getCopy();
            newComponent.setAssociation(newAssociation);
            this.m_component.getBroadcastJava().replaceChildAfter(this.m_component.getParentJava(), this.m_component, newComponent);
        }
    }

    private ConstructorCreationSupport getTargetCreationSupport(MorphingTargetDescription target) {
        CreationSupport creation;
        if (target.getCreationId() == null && (creation = this.m_component.getCreationSupport()) instanceof ConstructorCreationSupport) {
            ConstructorCreationSupport constructorCreation = (ConstructorCreationSupport)creation;
            String signature = constructorCreation.getDescription().getSignature();
            final Class<?> targetClass = target.getComponentClass();
            if (ReflectionUtils.getConstructorBySignature(targetClass, signature) != null) {
                final ClassInstanceCreation creationNode = constructorCreation.getCreation();
                String source = this.m_editor.getExternalSource((ASTNode)creationNode, new Function<ASTNode, String>(){

                    public String apply(ASTNode from) {
                        if (from == creationNode.getType()) {
                            return targetClass.getName();
                        }
                        return null;
                    }
                });
                return ConstructorCreationSupport.forSource(source);
            }
        }
        return new ConstructorCreationSupport(target.getCreationId(), false);
    }

    private abstract class MorphAction
    extends Action {
        private MorphAction() {
        }

        public final int hashCode() {
            return 0;
        }

        public final boolean equals(Object obj) {
            return obj instanceof MorphTargetAction;
        }

        public final void run() {
            MorphingTargetDescription target;
            try {
                target = this.getTarget();
                if (target == null) {
                    return;
                }
                String message = MorphingSupport.this.validate(target);
                if (message != null) {
                    MessageDialog.openError((Shell)DesignerPlugin.getShell(), (String)ModelMessages.MorphingSupport_incompatibleTargetTitle, (String)message);
                    return;
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
                return;
            }
            ExecutionUtils.run(MorphingSupport.this.m_component.getRootJava(), new RunnableEx(){

                public void run() throws Exception {
                    MorphingSupport.this.morph(target);
                }
            });
        }

        protected abstract MorphingTargetDescription getTarget() throws Exception;
    }

    private class MorphSubclassAction
    extends MorphAction {
        private final String m_baseClassName;

        public MorphSubclassAction(String baseClassName) {
            this.m_baseClassName = baseClassName;
        }

        protected MorphingTargetDescription getTarget() throws Exception {
            IJavaProject project = MorphingSupport.this.m_editor.getJavaProject();
            IType componentType = project.findType(this.m_baseClassName);
            SubtypesScope scope = new SubtypesScope(componentType);
            Shell shell = DesignerPlugin.getShell();
            ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)scope, (int)2, (boolean)false);
            dialog.setTitle(ModelMessages.MorphingSupport_chooseTitle);
            dialog.setMessage(ModelMessages.MorphingSupport_chooseMessage);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                String typeName = type.getFullyQualifiedName();
                Class<?> targetClass = EditorState.get(MorphingSupport.this.m_editor).getEditorLoader().loadClass(typeName);
                return new MorphingTargetDescription(targetClass, null);
            }
            return null;
        }
    }

    private class MorphTargetAction
    extends MorphAction {
        private final MorphingTargetDescription m_target;

        public MorphTargetAction(MorphingTargetDescription target) throws Exception {
            this.m_target = target;
            ComponentPresentation presentation = ComponentPresentationHelper.getPresentation(MorphingSupport.this.m_editor, target.getComponentClass().getName(), target.getCreationId());
            this.setImageDescriptor(new ImageImageDescriptor(presentation.getIcon()));
            this.setText(presentation.getName());
        }

        protected MorphingTargetDescription getTarget() throws Exception {
            return this.m_target;
        }
    }
}

