/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.ITextValuePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnumPropertyEditor
extends AbstractComboPropertyEditor
implements IValueSourcePropertyEditor,
ITextValuePropertyEditor,
IClipboardSourceProvider {
    @Override
    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof Enum) {
            Enum element = (Enum)value;
            return element.toString();
        }
        return null;
    }

    @Override
    public void setText(Property property, String text) throws Exception {
        Enum<?>[] enumArray = this.getElements(property);
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> element = enumArray[n2];
            if (element.toString().equals(text)) {
                this.setPropertyValue(property, element);
                break;
            }
            ++n2;
        }
    }

    @Override
    protected void addItems(Property property, CCombo3 combo) throws Exception {
        Enum<?>[] elements;
        Enum<?>[] enumArray = elements = this.getElements(property);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> element = enumArray[n2];
            combo.add(element.toString());
            ++n2;
        }
    }

    @Override
    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    @Override
    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        Enum<?>[] elements = this.getElements(property);
        Enum<?> element = elements[index];
        this.setPropertyValue(property, element);
    }

    protected abstract Enum<?>[] getElements(Property var1) throws Exception;

    protected void setPropertyValue(Property property, Enum<?> element) throws Exception {
        if (property instanceof GenericProperty) {
            GenericProperty genericProperty = (GenericProperty)property;
            String source = this.getValueSource(element);
            genericProperty.setExpression(source, element);
        } else {
            property.setValue(element);
        }
    }

    @Override
    public String getValueSource(Object value) throws Exception {
        if (value instanceof Enum) {
            Enum element = (Enum)value;
            return String.valueOf(ReflectionUtils.getFullyQualifiedName(element.getDeclaringClass(), false)) + "." + element.name();
        }
        return null;
    }

    @Override
    public String getClipboardSource(GenericProperty property) throws Exception {
        Object value = property.getValue();
        return this.getValueSource(value);
    }
}

