/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.controls.CComboBox;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public abstract class AbstractComboBoxPropertyEditor
extends TextDisplayPropertyEditor {
    private CComboBox m_combo;

    public final boolean activate(final PropertyTable propertyTable, final Property property, Point location) throws Exception {
        this.m_combo = new CComboBox((Composite)propertyTable, 0);
        this.fillItems(property, this.m_combo);
        this.selectCurrent(property, this.m_combo);
        this.m_combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 127: {
                        try {
                            property.setValue(Property.UNKNOWN_VALUE);
                        }
                        catch (Exception exception) {
                            propertyTable.handleException(exception);
                        }
                    }
                    case 27: {
                        e.doit = false;
                        AbstractComboBoxPropertyEditor.this.m_combo.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                propertyTable.deactivateEditor(false);
                            }
                        });
                    }
                }
            }
        });
        this.m_combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                propertyTable.deactivateEditor(true);
            }
        });
        this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractComboBoxPropertyEditor.this.toProperty(propertyTable, property);
            }
        });
        this.m_combo.setFocus();
        return true;
    }

    public final void deactivate(PropertyTable propertyTable, Property property, boolean save) {
        if (save) {
            try {
                this.toProperty(propertyTable, property);
            }
            catch (Throwable e) {
                propertyTable.deactivateEditor(false);
                propertyTable.handleException(e);
            }
        }
        if (this.m_combo != null) {
            this.m_combo.dispose();
            this.m_combo = null;
        }
    }

    public void setBounds(Rectangle bounds) {
        this.m_combo.setBounds(bounds);
    }

    protected abstract void fillItems(Property var1, CComboBox var2) throws Exception;

    protected abstract void selectCurrent(Property var1, CComboBox var2) throws Exception;

    private void toProperty(PropertyTable propertyTable, Property property) {
        try {
            this.toPropertyEx(property, this.m_combo);
        }
        catch (Exception e) {
            propertyTable.handleException(e);
        }
        propertyTable.deactivateEditor(false);
    }

    protected abstract void toPropertyEx(Property var1, CComboBox var2) throws Exception;
}

