/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.menu;

import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuObjectInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.core.utils.IAdaptable;
import org.eclipse.wb.internal.core.utils.IAdaptableFactory;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MenuObjectInfoUtils {
    public static IMenuObjectInfo m_selectingObject;

    public static void setSelectingObject(Object object) {
        m_selectingObject = MenuObjectInfoUtils.getMenuObjectInfo(object);
    }

    public static void setSelectingObject(IMenuObjectInfo selectingObject) {
        m_selectingObject = selectingObject;
    }

    public static IMenuObjectInfo getMenuObjectInfo(Object object) {
        return MenuObjectInfoUtils.getAdapter(object, IMenuObjectInfo.class);
    }

    public static IMenuPopupInfo getMenuPopupInfo(Object object) {
        return MenuObjectInfoUtils.getAdapter(object, IMenuPopupInfo.class);
    }

    public static IMenuInfo getMenuInfo(Object object) {
        return MenuObjectInfoUtils.getAdapter(object, IMenuInfo.class);
    }

    public static IMenuItemInfo getMenuItemInfo(Object object) {
        return MenuObjectInfoUtils.getAdapter(object, IMenuItemInfo.class);
    }

    public static IMenuInfo getSubMenu(IMenuObjectInfo object) {
        if (object instanceof IMenuPopupInfo) {
            return ((IMenuPopupInfo)object).getMenu();
        }
        if (object instanceof IMenuItemInfo) {
            return ((IMenuItemInfo)object).getMenu();
        }
        return null;
    }

    public static boolean isParentChild(IMenuObjectInfo parent, IMenuObjectInfo child) {
        if (parent == null || child == null) {
            return false;
        }
        if (parent == child) {
            return true;
        }
        if (parent instanceof IMenuPopupInfo) {
            return MenuObjectInfoUtils.isParentChild(((IMenuPopupInfo)parent).getMenu(), child);
        }
        if (parent instanceof IMenuItemInfo) {
            return MenuObjectInfoUtils.isParentChild(((IMenuItemInfo)parent).getMenu(), child);
        }
        if (parent instanceof IMenuInfo) {
            IMenuInfo parentMenu = (IMenuInfo)parent;
            for (IMenuItemInfo item : parentMenu.getItems()) {
                if (!MenuObjectInfoUtils.isParentChild(item, child)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isImplicitObject(Object reference) {
        if (reference instanceof JavaInfo) {
            JavaInfo model = (JavaInfo)reference;
            return model.getCreationSupport() instanceof IImplicitCreationSupport;
        }
        return false;
    }

    private static <T> T getAdapter(Object object, Class<T> adapter) {
        T adapted;
        if (object instanceof IAdaptable && (adapted = ((IAdaptable)object).getAdapter(adapter)) != null) {
            return adapted;
        }
        List<IAdaptableFactory> adaptableFactories = ExternalFactoriesHelper.getElementsInstances(IAdaptableFactory.class, "org.eclipse.wb.core.adaptableFactories", "factory");
        for (IAdaptableFactory adaptableFactory : adaptableFactories) {
            T adapted2 = adaptableFactory.getAdapter(object, adapter);
            if (adapted2 == null) continue;
            return adapted2;
        }
        return null;
    }
}

