/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generic;

import java.util.List;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleContainerClipboardSupport
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new SimpleContainerClipboardSupport();

    private SimpleContainerClipboardSupport() {
    }

    @Override
    public void process(JavaInfo root, List<JavaInfo> components) throws Exception {
        root.addBroadcastListener(new JavaEventListener(){

            @Override
            public void clipboardCopy(JavaInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
                List containers = SimpleContainerClipboardSupport.getSimpleContainers(javaInfo);
                int i = 0;
                while (i < containers.size()) {
                    SimpleContainer container = (SimpleContainer)containers.get(i);
                    Object child_ = container.getChild();
                    if (child_ instanceof JavaInfo) {
                        ClipboardCommand command = SimpleContainerClipboardSupport.createCommand(i, (JavaInfo)child_);
                        commands.add(command);
                    }
                    ++i;
                }
            }
        });
    }

    private static List<SimpleContainer> getSimpleContainers(JavaInfo javaInfo) {
        return new SimpleContainerFactory(javaInfo, true).get();
    }

    private static ClipboardCommand createCommand(final int containerIndex, JavaInfo child) throws Exception {
        final JavaInfoMemento memento = JavaInfoMemento.createMemento(child);
        ClipboardCommand command = new ClipboardCommand(){
            private static final long serialVersionUID = 0L;

            public void execute(JavaInfo newContainer) throws Exception {
                JavaInfo newChild = memento.create(newContainer);
                ((SimpleContainer)SimpleContainerClipboardSupport.getSimpleContainers(newContainer).get(containerIndex)).command_CREATE(newChild);
                memento.apply();
            }
        };
        return command;
    }
}

