/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.generation.GenerationDescription;
import org.eclipse.wb.internal.core.model.generation.preview.GenerationPreview;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.generation.statement.flat.FlatStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.VariableSupportDescription;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenerationSettings {
    public static final String P_DEDUCE_SETTINGS = "codeGeneration.deduceSettings";
    public static final String P_FORCED_METHOD = "codeGeneration.forcedMethod";
    private static final String P_VARIABLE_SUPPORT_ID = "codeGeneration.variableId";
    private static final String P_STATEMENT_GENERATOR_ID = "codeGeneration.statementId";
    private final IPreferenceStore m_store;
    private final Map<String, VariableSupportDescription> m_idToVariable = Maps.newTreeMap();
    private final Map<String, StatementGeneratorDescription> m_idToStatement = Maps.newTreeMap();
    private final List<VariableSupportDescription> m_variables = Lists.newArrayList();
    private final Map<VariableSupportDescription, StatementGeneratorDescription[]> m_variableToStatements = Maps.newHashMap();
    private final MultiKeyMap m_previewMap = new MultiKeyMap();
    private static final String CODE_GENERATION_PREFERENCES_KEY = "CODE_GENERATION_PREFERENCES_KEY";

    public GenerationSettings(IPreferenceStore store) {
        this.m_store = store;
    }

    public void addGenerators(VariableSupportDescription variable, StatementGeneratorDescription[] statements, GenerationPreview[] previews) {
        StatementGeneratorDescription statement;
        variable.configureDefaultPreferences(this.m_store);
        StatementGeneratorDescription[] statementGeneratorDescriptionArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            statement = statementGeneratorDescriptionArray[n2];
            statement.configureDefaultPreferences(this.m_store);
            ++n2;
        }
        this.m_idToVariable.put(variable.getId(), variable);
        statementGeneratorDescriptionArray = statements;
        n = statements.length;
        n2 = 0;
        while (n2 < n) {
            statement = statementGeneratorDescriptionArray[n2];
            this.m_idToStatement.put(statement.getId(), statement);
            ++n2;
        }
        Assert.isTrue(statements.length == previews.length);
        int i = 0;
        while (i < statements.length) {
            StatementGeneratorDescription statement2 = statements[i];
            GenerationPreview preview = previews[i];
            if (preview != null) {
                this.m_previewMap.put((Object)variable, (Object)statement2, (Object)preview);
            }
            ++i;
        }
        this.m_variables.add(variable);
        this.m_variableToStatements.put(variable, statements);
    }

    public void setDefaultDeduceSettings(boolean deduce) {
        this.m_store.setDefault(P_DEDUCE_SETTINGS, deduce);
    }

    public void setDeduceSettings(boolean deduce) {
        this.m_store.setValue(P_DEDUCE_SETTINGS, deduce);
    }

    public boolean shouldDeduceSettings() {
        return this.m_store.getBoolean(P_DEDUCE_SETTINGS);
    }

    public void setDefaultForcedMethodName(String forcedName) {
        this.m_store.setDefault(P_FORCED_METHOD, forcedName);
    }

    public String getForcedMethodName() {
        String methodName = this.m_store.getString(P_FORCED_METHOD);
        return StringUtils.isEmpty((String)methodName) ? null : methodName;
    }

    public VariableSupportDescription[] getVariables() {
        return this.m_variables.toArray(new VariableSupportDescription[this.m_variables.size()]);
    }

    public VariableSupportDescription getVariable() {
        String id = this.m_store.getString(P_VARIABLE_SUPPORT_ID);
        return this.getVariable(id);
    }

    public VariableSupportDescription getVariable(JavaInfo javaInfo) {
        String id = this.getPreferences(javaInfo).getString(P_VARIABLE_SUPPORT_ID);
        String script = JavaInfoUtils.getParameter(javaInfo, "variable.validateID");
        if (script != null) {
            ClassLoader coreClassLoader = this.getClass().getClassLoader();
            id = (String)ScriptUtils.evaluate(coreClassLoader, script, "id", id);
        }
        if ("org.eclipse.wb.core.model.variable.localUnique".equals(id) && NamesManager.shouldUseFieldInsteadOfLocal(javaInfo.getDescription())) {
            id = "org.eclipse.wb.core.model.variable.fieldUnique";
        }
        return this.getVariable(id);
    }

    public void setVariable(VariableSupportDescription variable) {
        this.m_store.setValue(P_VARIABLE_SUPPORT_ID, variable.getId());
    }

    public VariableSupportDescription getDefaultVariable() {
        String id = this.m_store.getDefaultString(P_VARIABLE_SUPPORT_ID);
        return this.getVariable(id);
    }

    public void setDefaultVariable(VariableSupportDescription description) {
        this.m_store.setDefault(P_VARIABLE_SUPPORT_ID, description.getId());
    }

    private VariableSupportDescription getVariable(String id) {
        VariableSupportDescription variable = this.m_idToVariable.get(id);
        Assert.isNotNull(variable, "Unable to find variable with id \"" + id + "\".");
        return variable;
    }

    public StatementGeneratorDescription[] getStatements(VariableSupportDescription variable) {
        return this.m_variableToStatements.get(variable);
    }

    public StatementGeneratorDescription getStatement() {
        String id = this.m_store.getString(P_STATEMENT_GENERATOR_ID);
        return this.getStatement(id);
    }

    public StatementGeneratorDescription getStatement(JavaInfo javaInfo) {
        String id = this.getPreferences(javaInfo).getString(P_STATEMENT_GENERATOR_ID);
        return this.getStatement(id);
    }

    public void setStatement(StatementGeneratorDescription statement) {
        this.m_store.setValue(P_STATEMENT_GENERATOR_ID, statement.getId());
    }

    public StatementGeneratorDescription getDefaultStatement() {
        String id = this.m_store.getDefaultString(P_STATEMENT_GENERATOR_ID);
        return this.getStatement(id);
    }

    public void setDefaultStatement(StatementGeneratorDescription description) {
        this.m_store.setDefault(P_STATEMENT_GENERATOR_ID, description.getId());
    }

    private StatementGeneratorDescription getStatement(String id) {
        StatementGeneratorDescription statement = this.m_idToStatement.get(id);
        Assert.isNotNull(statement, "Unable to find statement with id \"" + id + "\".");
        return statement;
    }

    public GenerationPreview getPreview(VariableSupportDescription variable, StatementGeneratorDescription statement) {
        return (GenerationPreview)this.m_previewMap.get((Object)variable, (Object)statement);
    }

    private IPreferenceStore getPreferences(JavaInfo javaInfo) {
        IPreferenceStore store = (IPreferenceStore)javaInfo.getEditor().getGlobalValue(CODE_GENERATION_PREFERENCES_KEY);
        return store != null ? store : this.m_store;
    }

    private void setPreferences(JavaInfo javaInfo, IPreferenceStore store) {
        javaInfo.getEditor().putGlobalValue(CODE_GENERATION_PREFERENCES_KEY, store);
    }

    public static void deduce(JavaInfo root) throws Exception {
        final Map settingsToComponents = Maps.newHashMap();
        root.accept(new ObjectInfoVisitor(){

            public void endVisit(ObjectInfo objectInfo) throws Exception {
                if (objectInfo instanceof AbstractComponentInfo) {
                    AbstractComponentInfo component = (AbstractComponentInfo)objectInfo;
                    GenerationSettings settings = component.getDescription().getToolkit().getGenerationSettings();
                    Set components = (Set)settingsToComponents.get(settings);
                    if (components == null) {
                        components = Sets.newHashSet();
                        settingsToComponents.put(settings, components);
                    }
                    components.add(component);
                }
            }
        });
        for (Map.Entry entry : settingsToComponents.entrySet()) {
            GenerationSettings settings = (GenerationSettings)entry.getKey();
            Set components = (Set)entry.getValue();
            settings.deduce(components);
        }
    }

    private void deduce(Set<AbstractComponentInfo> components) throws Exception {
        if (!this.m_store.getBoolean(P_DEDUCE_SETTINGS)) {
            return;
        }
        JavaInfo javaInfo = components.iterator().next();
        PreferenceStore editorPreferences = new PreferenceStore();
        this.setPreferences(javaInfo, (IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{editorPreferences, this.m_store}));
        this.deduceVariable(components, (IPreferenceStore)editorPreferences);
        this.deduceStatement(components, (IPreferenceStore)editorPreferences);
        VariableSupportDescription variableDescription = this.getVariable(javaInfo);
        StatementGeneratorDescription statementDescription = this.getStatement(javaInfo);
        Object[] compatibleStatements = this.getStatements(variableDescription);
        if (!ArrayUtils.contains((Object[])compatibleStatements, (Object)statementDescription)) {
            editorPreferences.setValue(P_STATEMENT_GENERATOR_ID, ((GenerationDescription)compatibleStatements[0]).getId());
        }
    }

    private void deduceVariable(Set<AbstractComponentInfo> components, IPreferenceStore store) {
        int componentCount = 0;
        Map variableToCount = Maps.newHashMap();
        for (AbstractComponentInfo component : components) {
            VariableSupport variableSupport = component.getVariableSupport();
            VariableSupportDescription variableDescription = this.getVariableDescription(variableSupport);
            if (variableDescription == null) continue;
            ++componentCount;
            Integer count = (Integer)variableToCount.get(variableDescription);
            variableToCount.put(variableDescription, count == null ? 1 : count + 1);
        }
        if (componentCount >= 3) {
            VariableSupportDescription variableDescription = (VariableSupportDescription)GenerationSettings.getMaxElement(variableToCount);
            store.setValue(P_VARIABLE_SUPPORT_ID, variableDescription.getId());
        }
    }

    private void deduceStatement(Set<AbstractComponentInfo> components, IPreferenceStore store) throws Exception {
        int componentCount = 0;
        Map blockToCount = Maps.newHashMap();
        for (AbstractComponentInfo component : components) {
            Integer count;
            VariableSupport variableSupport = component.getVariableSupport();
            if (this.getVariableDescription(variableSupport) == null) continue;
            ++componentCount;
            StatementTarget target = variableSupport.getStatementTarget();
            Block block = target.getBlock();
            if (block == null) {
                block = AstNodeUtils.getEnclosingBlock((ASTNode)target.getStatement());
            }
            blockToCount.put(block, (count = (Integer)blockToCount.get(block)) == null ? 1 : count + 1);
        }
        if (componentCount >= 3) {
            int singleCount = 0;
            int multipleCount = 0;
            for (Integer count : blockToCount.values()) {
                if (count == 1) {
                    ++singleCount;
                    continue;
                }
                multipleCount += count.intValue();
            }
            StatementGeneratorDescription statementDescription = singleCount >= multipleCount ? BlockStatementGeneratorDescription.INSTANCE : FlatStatementGeneratorDescription.INSTANCE;
            store.setValue(P_STATEMENT_GENERATOR_ID, statementDescription.getId());
        }
    }

    private VariableSupportDescription getVariableDescription(VariableSupport variableSupport) {
        for (VariableSupportDescription variableDescription : this.m_variables) {
            if (variableSupport.getClass() != variableDescription.getType()) continue;
            return variableDescription;
        }
        return null;
    }

    private static <T> T getMaxElement(Map<T, Integer> elementToCount) {
        Assert.isTrue(!elementToCount.isEmpty());
        T maxElement = elementToCount.keySet().iterator().next();
        int maxCardinality = elementToCount.get(maxElement);
        for (Map.Entry<T, Integer> entry : elementToCount.entrySet()) {
            if (entry.getValue() <= maxCardinality) continue;
            maxElement = entry.getKey();
            maxCardinality = entry.getValue();
        }
        return maxElement;
    }
}

