/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescriptionKey;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.IDescriptionProcessor;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.EditorStateLoadingContext;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.ClassResourceInfo;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.model.description.rules.ConfigurableObjectListParameterRule;
import org.eclipse.wb.internal.core.model.description.rules.ConfigurableObjectParameterRule;
import org.eclipse.wb.internal.core.model.description.rules.ConfigurablePropertyRule;
import org.eclipse.wb.internal.core.model.description.rules.ConstructorRule;
import org.eclipse.wb.internal.core.model.description.rules.CreationTagRule;
import org.eclipse.wb.internal.core.model.description.rules.CreationTypeParametersRule;
import org.eclipse.wb.internal.core.model.description.rules.ExposingRulesRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodOrderDefaultRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodOrderMethodRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodOrderMethodsRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodOrderMethodsSignatureRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodPropertyRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodSinglePropertyRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodTagRule;
import org.eclipse.wb.internal.core.model.description.rules.MethodsOperationRule;
import org.eclipse.wb.internal.core.model.description.rules.ModelClassRule;
import org.eclipse.wb.internal.core.model.description.rules.MorphingNoInheritRule;
import org.eclipse.wb.internal.core.model.description.rules.MorphingTargetRule;
import org.eclipse.wb.internal.core.model.description.rules.ObjectCreateRule;
import org.eclipse.wb.internal.core.model.description.rules.ParameterEditorRule;
import org.eclipse.wb.internal.core.model.description.rules.ParameterTagRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyAccessRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyCategoryRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyDefaultRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyEditorRule;
import org.eclipse.wb.internal.core.model.description.rules.PropertyGetterRule;
import org.eclipse.wb.internal.core.model.description.rules.PublicFieldPropertiesRule;
import org.eclipse.wb.internal.core.model.description.rules.SetClassPropertyRule;
import org.eclipse.wb.internal.core.model.description.rules.SetListedPropertiesRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesAdvancedRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesHiddenRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesNoDefaultValueRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesNormalRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesPreferredRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertiesRule;
import org.eclipse.wb.internal.core.model.description.rules.StandardBeanPropertyTagRule;
import org.eclipse.wb.internal.core.model.description.rules.ToolkitRule;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstParser;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.utils.reflect.IntrospectionHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.ImageDisposer;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentDescriptionHelper {
    private static final ClassMap<ComponentDescription> m_getDescription_Class = ClassMap.create();

    private ComponentDescriptionHelper() {
    }

    public static ComponentDescription getDescription(AstEditor editor, FactoryMethodDescription factoryMethodDescription) throws Exception {
        Class<?> componentClass = factoryMethodDescription.getReturnClass();
        String signature = factoryMethodDescription.getSignature();
        String signatureUnix = StringUtils.replaceChars((String)signature, (String)"(,)", (String)"___");
        Class<?> declaringClass = factoryMethodDescription.getDeclaringClass();
        ComponentDescriptionKey declaringKey = new ComponentDescriptionKey(declaringClass);
        ComponentDescriptionKey key = new ComponentDescriptionKey(componentClass, declaringKey, signatureUnix);
        return ComponentDescriptionHelper.getKeySpecificDescription(editor, componentClass, key);
    }

    public static ComponentDescription getDescription(AstEditor editor, ComponentDescription hostDescription, Method method) throws Exception {
        Class<?> componentClass = method.getReturnType();
        String suffix = method.getName();
        ComponentDescriptionKey key = new ComponentDescriptionKey(componentClass, hostDescription.getKey(), suffix);
        return ComponentDescriptionHelper.getKeySpecificDescription(editor, componentClass, key);
    }

    public static ComponentDescription getDescription(AstEditor editor, ComponentDescription hostDescription, SingleVariableDeclaration parameter) throws Exception {
        String parameterClassName = AstNodeUtils.getFullyQualifiedName(parameter.getType(), true);
        Class<?> parameterClass = EditorState.get(editor).getEditorLoader().loadClass(parameterClassName);
        MethodDeclaration methodDeclaration = (MethodDeclaration)parameter.getParent();
        String signature = AstNodeUtils.getMethodSignature(methodDeclaration);
        String signatureUnix = StringUtils.replaceChars((String)signature, (String)"(,)", (String)"___");
        int parameterIndex = DomGenerics.parameters(methodDeclaration).indexOf(parameter);
        String suffix = String.valueOf(signatureUnix) + "." + parameterIndex;
        List additionalDescriptions = Lists.newArrayList();
        Class<?> hostComponentClass = hostDescription.getComponentClass();
        while (hostComponentClass != null) {
            String descriptionPath;
            ComponentDescriptionKey hostKey = new ComponentDescriptionKey(hostComponentClass);
            EditorState state = EditorState.get(editor);
            ILoadingContext context = EditorStateLoadingContext.get(state);
            ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(context, hostComponentClass, descriptionPath = String.valueOf(hostKey.getName()) + "." + suffix + ".wbp-component.xml");
            if (resourceInfo != null) {
                ClassResourceInfo descriptionInfo = new ClassResourceInfo(parameterClass, resourceInfo);
                additionalDescriptions.add(descriptionInfo);
            }
            hostComponentClass = hostComponentClass.getSuperclass();
        }
        if (additionalDescriptions.isEmpty()) {
            return ComponentDescriptionHelper.getDescription(editor, parameterClass);
        }
        ComponentDescriptionKey key = new ComponentDescriptionKey(parameterClass, hostDescription.getKey(), suffix);
        return ComponentDescriptionHelper.getDescription0(editor, key, additionalDescriptions);
    }

    public static ComponentDescription getDescription(AstEditor editor, Class<?> componentClass) throws Exception {
        ComponentDescription description = m_getDescription_Class.get(componentClass);
        if (description == null) {
            description = ComponentDescriptionHelper.getDescription0(editor, componentClass);
            m_getDescription_Class.put(componentClass, description);
        }
        return description;
    }

    private static ComponentDescription getDescription0(AstEditor editor, Class<?> componentClass) throws Exception {
        String innerPart;
        String componentClassName;
        int index;
        while ((index = (componentClassName = componentClass.getName()).indexOf(36)) != -1 && componentClass.getInterfaces().length == 0 && StringUtils.isNumeric((String)(innerPart = componentClassName.substring(index + 1)))) {
            componentClass = componentClass.getSuperclass();
        }
        ComponentDescriptionKey key = new ComponentDescriptionKey(componentClass);
        return ComponentDescriptionHelper.getDescription0(editor, key, (List)ImmutableList.of());
    }

    public static ComponentDescription getDescription(AstEditor editor, String componentClassName) throws Exception {
        Class<?> componentClass = EditorState.get(editor).getEditorLoader().loadClass(componentClassName);
        return ComponentDescriptionHelper.getDescription(editor, componentClass);
    }

    private static ComponentDescription getKeySpecificDescription(AstEditor editor, Class<?> componentClass, ComponentDescriptionKey key) throws Exception {
        String descriptionPath;
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        ResourceInfo resourceInfo = DescriptionHelper.getResourceInfo(context, componentClass, descriptionPath = String.valueOf(key.getName()) + ".wbp-component.xml");
        if (resourceInfo == null) {
            return ComponentDescriptionHelper.getDescription(editor, componentClass);
        }
        ClassResourceInfo descriptionInfo = new ClassResourceInfo(componentClass, resourceInfo);
        return ComponentDescriptionHelper.getDescription0(editor, key, (List)ImmutableList.of((Object)descriptionInfo));
    }

    private static ComponentDescription getDescription0(AstEditor editor, ComponentDescriptionKey key, List<ClassResourceInfo> additionalDescriptionInfos) throws Exception {
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        Class<?> componentClass = key.getComponentClass();
        try {
            ComponentDescription componentDescription = new ComponentDescription(key);
            ComponentDescriptionHelper.addConstructors(editor.getJavaProject(), componentDescription);
            componentDescription.setBeanInfo(ReflectionUtils.getBeanInfo(componentClass));
            componentDescription.setBeanDescriptor(new IntrospectionHelper(componentClass).getBeanDescriptor());
            LinkedList descriptionInfos = Lists.newLinkedList();
            DescriptionHelper.addDescriptionResources(descriptionInfos, context, componentClass);
            Assert.isTrueException(!descriptionInfos.isEmpty(), 500, componentClass.getName());
            descriptionInfos.addAll(additionalDescriptionInfos);
            Digester digester = new Digester();
            digester.setLogger((Log)new NoOpLog());
            ComponentDescriptionHelper.addRules(digester, editor, componentClass);
            for (ClassResourceInfo descriptionInfo : descriptionInfos) {
                ResourceInfo resourceInfo = descriptionInfo.resource;
                componentDescription.setCurrentClass(descriptionInfo.clazz);
                digester.push((Object)componentDescription);
                InputStream is = resourceInfo.getURL().openStream();
                try {
                    digester.parse(is);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
                if (descriptionInfo.clazz == componentClass) {
                    ComponentDescriptionHelper.setDescriptionWithInnerTags(componentDescription, resourceInfo);
                    continue;
                }
                componentDescription.clearCreations();
                componentDescription.setDescription(null);
            }
            if (componentDescription.getToolkit() == null) {
                int i = descriptionInfos.size() - 1;
                while (i >= 0) {
                    ClassResourceInfo descriptionInfo = (ClassResourceInfo)descriptionInfos.get(i);
                    ToolkitDescription toolkit = descriptionInfo.resource.getToolkit();
                    if (toolkit != null) {
                        componentDescription.setToolkit(toolkit);
                        break;
                    }
                    --i;
                }
                Assert.isTrueException(componentDescription.getToolkit() != null, 503, componentClass.getName());
            }
            ComponentDescriptionHelper.setIcon(context, componentDescription, componentClass);
            ComponentDescriptionHelper.configureDefaultCreation(componentDescription);
            Assert.isNotNull(componentDescription.getModelClass());
            componentDescription.joinProperties();
            if (key.isPureComponent() && !"true".equals(componentDescription.getParameter("dontCacheDescription")) && ComponentDescriptionHelper.shouldCacheDescriptions_inPackage((ClassResourceInfo)descriptionInfos.getLast(), componentClass)) {
                componentDescription.setCached(true);
            }
            if (ComponentDescriptionHelper.shouldCachePresentation((ClassResourceInfo)descriptionInfos.getLast(), componentClass)) {
                componentDescription.setPresentationCached(true);
            }
            for (IDescriptionProcessor processor : ComponentDescriptionHelper.getDescriptionProcessors()) {
                processor.process(editor, componentDescription);
            }
            return componentDescription;
        }
        catch (SAXParseException e) {
            throw new DesignerException(502, (Throwable)e.getException(), componentClass.getName());
        }
    }

    private static void setDescriptionWithInnerTags(ComponentDescription componentDescription, ResourceInfo resourceInfo) throws Exception {
        InputStream stream = resourceInfo.getURL().openStream();
        String string = IOUtils2.readString(stream);
        String description = StringUtils.substringBetween((String)string, (String)"<description>", (String)"</description>");
        if (description != null) {
            componentDescription.setDescription(description);
        }
    }

    private static void configureDefaultCreation(ComponentDescription componentDescription) {
        Class<?> componentClass = componentDescription.getComponentClass();
        Constructor<?> constructor = ReflectionUtils.getShortestConstructor(componentClass);
        if (constructor == null) {
            return;
        }
        String source = ComponentDescriptionHelper.getDefaultConstructorInvocation(constructor);
        CreationDescription creationDefault = new CreationDescription(componentDescription, null, null);
        creationDefault.setSource(source);
        componentDescription.setCreationDefault(creationDefault);
    }

    public static String getDefaultConstructorInvocation(Constructor<?> constructor) {
        Class<?> componentClass = constructor.getDeclaringClass();
        String componentClassName = ReflectionUtils.getCanonicalName(componentClass);
        StringBuilder buffer = new StringBuilder();
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameter = classArray[n2];
            String parameterName = ReflectionUtils.getCanonicalName(parameter);
            buffer.append(AstParser.getDefaultValue(parameterName));
            buffer.append(", ");
            ++n2;
        }
        String arguments = StringUtils.removeEnd((String)buffer.toString(), (String)", ");
        return "new " + componentClassName + "(" + arguments + ")";
    }

    private static void setIcon(ILoadingContext context, ComponentDescription componentDescription, Class<?> currentClass) throws Exception {
        if (currentClass != null) {
            Image icon;
            if (componentDescription.getIcon() == null && (icon = DescriptionHelper.getIconImage(context, currentClass)) != null) {
                componentDescription.setIcon(icon);
                String name = componentDescription.getComponentClass().getName();
                ImageDisposer.add(componentDescription, name, icon);
                return;
            }
            Class<?>[] classArray = currentClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                if (componentDescription.getIcon() == null) {
                    ComponentDescriptionHelper.setIcon(context, componentDescription, interfaceClass);
                }
                ++n2;
            }
            if (componentDescription.getIcon() == null) {
                ComponentDescriptionHelper.setIcon(context, componentDescription, currentClass.getSuperclass());
            }
        }
    }

    public static void ensureInitialized(final IJavaProject javaProject, final AbstractInvocationDescription methodDescription) {
        if (!methodDescription.isInitialized()) {
            methodDescription.setInitialized(true);
            ExecutionUtils.runIgnore(new RunnableEx(){

                public void run() throws Exception {
                    IMethod method = CodeUtils.findMethod(javaProject, methodDescription.getDeclaringClass().getName(), methodDescription.getSignature());
                    if (method != null) {
                        String[] parameterNames = method.getParameterNames();
                        for (ParameterDescription parameter : methodDescription.getParameters()) {
                            if (parameter.getName() != null) continue;
                            int parameterIndex = parameter.getIndex();
                            String parameterName = parameterNames[parameterIndex];
                            parameter.setName(parameterName);
                        }
                    }
                }
            });
        }
    }

    private static void addConstructors(IJavaProject javaProject, ComponentDescription componentDescription) throws Exception {
        Class<?> componentClass = componentDescription.getComponentClass();
        Constructor<?>[] constructorArray = componentClass.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            constructor.setAccessible(true);
            ConstructorDescription constructorDescription = new ConstructorDescription(componentClass);
            Class<?>[] classArray = constructor.getParameterTypes();
            int n3 = classArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> parameterType = classArray[n4];
                ComponentDescriptionHelper.addParameter(constructorDescription, parameterType);
                ++n4;
            }
            constructorDescription.postProcess();
            componentDescription.addConstructor(constructorDescription);
            ++n2;
        }
    }

    private static void addParameter(AbstractInvocationDescription description, Class<?> parameterType) throws Exception {
        ParameterDescription parameterDescription = new ParameterDescription();
        parameterDescription.setType(parameterType);
        description.addParameter(parameterDescription);
    }

    private static void addRules(Digester digester, AstEditor editor, Class<?> componentClass) {
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        digester.addRule("component/toolkit", (Rule)new ToolkitRule());
        digester.addRule("component/model", (Rule)new ModelClassRule());
        String pattern = "component/order";
        digester.addCallMethod(pattern, "setOrder", 1);
        digester.addCallParam(pattern, 0);
        digester.addRule("component/standard-bean-properties", (Rule)new StandardBeanPropertiesRule());
        digester.addRule("component/properties-preferred", (Rule)new StandardBeanPropertiesPreferredRule());
        digester.addRule("component/properties-normal", (Rule)new StandardBeanPropertiesNormalRule());
        digester.addRule("component/properties-advanced", (Rule)new StandardBeanPropertiesAdvancedRule());
        digester.addRule("component/properties-hidden", (Rule)new StandardBeanPropertiesHiddenRule());
        digester.addRule("component/properties-noDefaultValue", (Rule)new StandardBeanPropertiesNoDefaultValueRule());
        digester.addRule("component/property-tag", (Rule)new StandardBeanPropertyTagRule());
        pattern = "component/method-single-property";
        digester.addRule(pattern, (Rule)new MethodSinglePropertyRule());
        ComponentDescriptionHelper.addPropertyConfigurationRules(digester, state, pattern);
        digester.addRule("component/method-property", (Rule)new MethodPropertyRule(editor.getJavaProject()));
        digester.addRule("component/public-field-properties", (Rule)new PublicFieldPropertiesRule());
        ComponentDescriptionHelper.addCreationRules(digester, context, "component/creation", "addCreation");
        digester.addRule("component/creation/tag", (Rule)new CreationTagRule());
        digester.addRule("component/creation/typeParameters/typeParameter", (Rule)new CreationTypeParametersRule());
        ComponentDescriptionHelper.addCreationRules(digester, context, "component/creation-default", "setCreationDefault");
        digester.addRule("component/creation-default/tag", (Rule)new CreationTagRule());
        pattern = "component/morphTargets/morphTarget";
        digester.addRule(pattern, (Rule)new MorphingTargetRule(state));
        pattern = "component/morphTargets/noInherit";
        digester.addRule(pattern, (Rule)new MorphingNoInheritRule());
        pattern = "component/description";
        digester.addCallMethod(pattern, "setDescription", 1);
        digester.addCallParam(pattern, 0);
        pattern = "component/constructors/constructor";
        digester.addRule(pattern, (Rule)new ConstructorRule());
        digester.addSetProperties(pattern);
        ComponentDescriptionHelper.addParametersRules(digester, String.valueOf(pattern) + "/parameter", state);
        pattern = "component/methods/method";
        digester.addRule(pattern, (Rule)new MethodRule());
        digester.addRule(pattern, (Rule)new SetListedPropertiesRule(new String[]{"order"}, new String[]{"orderSpecification"}));
        digester.addRule(String.valueOf(pattern) + "/tag", (Rule)new MethodTagRule());
        ComponentDescriptionHelper.addParametersRules(digester, String.valueOf(pattern) + "/parameter", state);
        pattern = "component/method-order";
        digester.addRule(String.valueOf(pattern) + "/default", (Rule)new MethodOrderDefaultRule());
        digester.addRule(String.valueOf(pattern) + "/method", (Rule)new MethodOrderMethodRule());
        digester.addRule(String.valueOf(pattern) + "/methods", (Rule)new MethodOrderMethodsRule());
        digester.addRule(String.valueOf(pattern) + "/methods/s", (Rule)new MethodOrderMethodsSignatureRule());
        pattern = "component/exposing-rules";
        digester.addRule(String.valueOf(pattern) + "/include", (Rule)new ExposingRulesRule());
        digester.addRule(String.valueOf(pattern) + "/exclude", (Rule)new ExposingRulesRule());
        digester.addRule("component/methods/methods-include", (Rule)new MethodsOperationRule(true));
        digester.addRule("component/methods/methods-exclude", (Rule)new MethodsOperationRule(false));
        pattern = "component/parameters/parameter";
        digester.addCallMethod(pattern, "addParameter", 2);
        digester.addCallParam(pattern, 0, "name");
        digester.addCallParam(pattern, 1);
        ComponentDescriptionHelper.addPropertiesRules(digester, state);
        ComponentDescriptionHelper.addConfigurablePropertiesRules(digester, state);
    }

    private static void addPropertiesRules(Digester digester, EditorState state) {
        String propertyAccessPattern = "component/property";
        digester.addRule(propertyAccessPattern, (Rule)new PropertyAccessRule());
        ComponentDescriptionHelper.addPropertyConfigurationRules(digester, state, propertyAccessPattern);
    }

    private static void addPropertyConfigurationRules(Digester digester, EditorState state, String propertyAccessPattern) {
        String pattern = String.valueOf(propertyAccessPattern) + "/category";
        digester.addRule(pattern, (Rule)new PropertyCategoryRule());
        pattern = String.valueOf(propertyAccessPattern) + "/editor";
        digester.addRule(pattern, (Rule)new PropertyEditorRule(state));
        ComponentDescriptionHelper.addConfigurableObjectParametersRules(digester, pattern);
        pattern = String.valueOf(propertyAccessPattern) + "/defaultValue";
        ClassLoader classLoader = state.getEditorLoader();
        digester.addRule(pattern, (Rule)new PropertyDefaultRule(classLoader));
        pattern = String.valueOf(propertyAccessPattern) + "/getter";
        digester.addRule(pattern, (Rule)new PropertyGetterRule());
    }

    private static void addConfigurablePropertiesRules(Digester digester, EditorState state) {
        String pattern = "component/add-property";
        digester.addRule(pattern, (Rule)new ConfigurablePropertyRule());
        ComponentDescriptionHelper.addConfigurableObjectParametersRules(digester, pattern);
    }

    private static void addConfigurableObjectParametersRules(Digester digester, String pattern) {
        digester.addRule(String.valueOf(pattern) + "/parameter", (Rule)new ConfigurableObjectParameterRule());
        digester.addRule(String.valueOf(pattern) + "/parameter-list", (Rule)new ConfigurableObjectListParameterRule());
    }

    private static void addCreationRules(Digester digester, final ILoadingContext context, String basePattern, String setCreationMethod) {
        digester.addFactoryCreate(basePattern, (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
                String id = attributes.getValue("id");
                String name = attributes.getValue("name");
                CreationDescription creation = new CreationDescription(componentDescription, id, name);
                if (id != null) {
                    Class<?> componentClass = componentDescription.getComponentClass();
                    String suffix = "_" + id;
                    creation.setIcon(DescriptionHelper.getIconImage(context, componentClass, suffix));
                }
                return creation;
            }
        });
        digester.addSetNext(basePattern, setCreationMethod);
        String pattern = String.valueOf(basePattern) + "/description";
        digester.addCallMethod(pattern, "setDescription", 1);
        digester.addCallParam(pattern, 0);
        pattern = String.valueOf(basePattern) + "/source";
        digester.addCallMethod(pattern, "setSource", 1);
        digester.addCallParam(pattern, 0);
        pattern = String.valueOf(basePattern) + "/invocation";
        digester.addRule(pattern, (Rule)new ObjectCreateRule(CreationInvocationDescription.class));
        digester.addRule(pattern, (Rule)new SetListedPropertiesRule(new String[]{"signature"}));
        digester.addCallMethod(pattern, "setArguments", 1);
        digester.addCallParam(pattern, 0);
        digester.addSetNext(pattern, "addInvocation");
        pattern = String.valueOf(basePattern) + "/parameter";
        digester.addCallMethod(pattern, "addParameter", 2);
        digester.addCallParam(pattern, 0, "name");
        digester.addCallParam(pattern, 1);
    }

    static void addParametersRules(Digester digester, String pattern, EditorState state) {
        ClassLoader classLoader = state.getEditorLoader();
        digester.addRule(pattern, (Rule)new ObjectCreateRule(ParameterDescription.class));
        digester.addRule(pattern, (Rule)new SetClassPropertyRule(classLoader, "type"));
        digester.addRule(pattern, (Rule)new SetListedPropertiesRule(new String[]{"name", "defaultSource", "parent", "child", "property", "parent2", "child2"}));
        digester.addSetNext(pattern, "addParameter");
        String editorPattern = String.valueOf(pattern) + "/editor";
        digester.addRule(editorPattern, (Rule)new ParameterEditorRule(state));
        ComponentDescriptionHelper.addConfigurableObjectParametersRules(digester, editorPattern);
        digester.addRule(String.valueOf(pattern) + "/tag", (Rule)new ParameterTagRule());
    }

    private static boolean shouldCacheDescriptions_inPackage(ClassResourceInfo descriptionInfo, Class<?> componentClass) throws Exception {
        return ComponentDescriptionHelper.hasMarkerFileForPackage(descriptionInfo, componentClass, ".wbp-cache-descriptions");
    }

    private static boolean shouldCachePresentation(ClassResourceInfo descriptionInfo, Class<?> componentClass) throws Exception {
        Bundle bundle;
        if (descriptionInfo.clazz == componentClass && (bundle = descriptionInfo.resource.getBundle()) != null) {
            return bundle.getEntry("wbp-meta/.wbp-cache-presentations") != null;
        }
        return false;
    }

    private static boolean hasMarkerFileForPackage(ClassResourceInfo descriptionInfo, Class<?> componentClass, String markerFileName) throws Exception {
        ResourceInfo resourceInfo = descriptionInfo.resource;
        if (resourceInfo.getBundle() != null) {
            String packageName = CodeUtils.getPackage(componentClass.getName());
            String markerName = String.valueOf(packageName.replace('.', '/')) + "/" + markerFileName;
            return DescriptionHelper.getResourceInfo(null, resourceInfo.getBundle(), markerName) != null;
        }
        return false;
    }

    public static List<IDescriptionProcessor> getDescriptionProcessors() {
        return ExternalFactoriesHelper.getElementsInstances(IDescriptionProcessor.class, "org.eclipse.wb.core.descriptionProcessors", "processor");
    }
}

