/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentDescriptionKey {
    private final Class<?> m_componentClass;
    private final ComponentDescriptionKey m_host;
    private final String m_suffix;

    public ComponentDescriptionKey(Class<?> componentClass) {
        this(componentClass, null, null);
    }

    public ComponentDescriptionKey(Class<?> componentClass, ComponentDescriptionKey host, String suffix) {
        Assert.isNotNull(componentClass);
        Assert.isLegal(!(host != null ^ suffix != null), "Host and suffix should both be null or not null.");
        this.m_componentClass = componentClass;
        this.m_host = host;
        this.m_suffix = suffix;
    }

    public int hashCode() {
        return this.m_componentClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentDescriptionKey) {
            ComponentDescriptionKey key = (ComponentDescriptionKey)obj;
            return this.m_componentClass == key.m_componentClass && ObjectUtils.equals((Object)this.m_host, (Object)key.m_host) && ObjectUtils.equals((Object)this.m_suffix, (Object)key.m_suffix);
        }
        return false;
    }

    public String toString() {
        String s = "CDKey(";
        s = String.valueOf(s) + this.m_componentClass.getName();
        if (this.m_host != null) {
            s = String.valueOf(s) + "," + this.m_host.toString() + "," + this.m_suffix;
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public Class<?> getComponentClass() {
        return this.m_componentClass;
    }

    public boolean isPureComponent() {
        return this.m_host == null;
    }

    public String getName() {
        if (this.m_host != null) {
            return String.valueOf(this.m_host.getName()) + "." + this.m_suffix;
        }
        return this.m_componentClass.getName().replace('.', '/');
    }
}

