/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.WrapperByMethod;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.WrappedObjectAssociation;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class WrapperMethodCreationSupport
extends CreationSupport {
    protected final WrapperByMethod m_wrapper;
    private MethodInvocation m_invocation;

    public WrapperMethodCreationSupport(WrapperByMethod wrapper) {
        this.m_wrapper = wrapper;
    }

    public String toString() {
        return "method: " + ReflectionUtils.toString(this.m_wrapper.getControlMethod());
    }

    public ASTNode getNode() {
        return this.m_invocation;
    }

    public boolean isJavaInfo(ASTNode node) {
        return this.m_invocation != null && node == this.m_invocation;
    }

    public Association getAssociation() throws Exception {
        return new WrappedObjectAssociation(this.m_wrapper);
    }

    public String add_getSource(NodeTarget target) throws Exception {
        String wrapperSource = this.m_wrapper.getWrapperInfo().getCreationSupport().add_getSource(target);
        String controlName = this.m_wrapper.getControlMethod().getName();
        return TemplateUtils.format("{0}.{1}()", wrapperSource, controlName);
    }

    public void add_setSourceExpression(Expression expression) throws Exception {
        this.m_invocation = (MethodInvocation)expression;
        Expression viewerCreation = this.m_invocation.getExpression();
        JavaInfo wrapperInfo = this.m_wrapper.getWrapperInfo();
        wrapperInfo.getCreationSupport().add_setSourceExpression(viewerCreation);
        wrapperInfo.addRelatedNode((ASTNode)viewerCreation);
        wrapperInfo.setAssociation(wrapperInfo.getCreationSupport().getAssociation());
        wrapperInfo.setVariableSupport(new EmptyVariableSupport(wrapperInfo, viewerCreation));
        if (this.shouldUseFieldForWrapper()) {
            wrapperInfo.getVariableSupport().convertLocalToField();
        } else {
            wrapperInfo.getVariableSupport().convertFieldToLocal();
        }
        this.m_javaInfo.addChild(wrapperInfo);
        this.m_javaInfo.setCreationSupport(this.newControlCreationSupport());
        this.m_javaInfo.bindToExpression((Expression)this.m_invocation);
    }

    private boolean shouldUseFieldForWrapper() {
        JavaInfo wrapperInfo = this.m_wrapper.getWrapperInfo();
        GenerationSettings settings = wrapperInfo.getDescription().getToolkit().getGenerationSettings();
        return settings.getVariable(wrapperInfo) instanceof FieldUniqueVariableDescription;
    }

    protected CreationSupport newControlCreationSupport() {
        return new WrapperMethodControlCreationSupport(this.m_wrapper);
    }
}

