/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ICreationSupportPermissions;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;

public class OpaqueCreationSupport
extends CreationSupport {
    private ICreationSupportPermissions m_permissions = ICreationSupportPermissions.FALSE;
    private String m_source;
    private Expression m_expression;

    public OpaqueCreationSupport(String source) {
        this.m_source = source;
    }

    public OpaqueCreationSupport(Expression expression) {
        this.m_expression = expression;
    }

    public String toString() {
        return "opaque";
    }

    public void setPermissions(ICreationSupportPermissions permissions) {
        this.m_permissions = permissions;
    }

    public ASTNode getNode() {
        return this.m_expression;
    }

    public boolean isJavaInfo(ASTNode node) {
        return node == this.m_expression;
    }

    public boolean canDelete() {
        return this.m_permissions.canDelete(this.m_javaInfo);
    }

    public void delete() throws Exception {
        this.m_permissions.delete(this.m_javaInfo);
    }

    public boolean canReorder() {
        return this.m_permissions.canReorder(this.m_javaInfo);
    }

    public boolean canReparent() {
        return this.m_permissions.canReparent(this.m_javaInfo);
    }

    public String add_getSource(NodeTarget target) throws Exception {
        return this.m_source;
    }

    public void add_setSourceExpression(Expression expression) throws Exception {
        this.m_expression = expression;
        this.m_javaInfo.bindToExpression(expression);
    }
}

