/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class SimpleNameEvaluator
implements IExpressionEvaluator {
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (expression instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)expression;
            Object value = this.evaluateAsConstant(context, simpleName);
            if (value != AstEvaluationEngine.UNKNOWN) {
                return value;
            }
            return this.evaluateAsAssignment(context, simpleName);
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private Object evaluateAsConstant(EvaluationContext context, SimpleName simpleName) throws Exception {
        ITypeBinding declaringClassBinding;
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)simpleName);
        if (variableBinding != null && (declaringClassBinding = variableBinding.getDeclaringClass()) != null) {
            String declaringClassName = AstNodeUtils.getFullyQualifiedName(declaringClassBinding, true);
            if (SimpleNameEvaluator.isNameOfTopTypeDeclaration((ASTNode)simpleName, declaringClassName)) {
                return AstEvaluationEngine.UNKNOWN;
            }
            Class<?> declaringClass = context.getClassLoader().loadClass(declaringClassName);
            Field field = ReflectionUtils.getFieldByName(declaringClass, simpleName.getIdentifier());
            if (field != null && Modifier.isStatic(field.getModifiers())) {
                return field.get(null);
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static boolean isNameOfTopTypeDeclaration(ASTNode node, String typeName) {
        TypeDeclaration topTypeDeclaration = AstNodeUtils.getEnclosingTypeTop(node);
        return AstNodeUtils.getFullyQualifiedName(topTypeDeclaration, false).equals(typeName);
    }

    private Object evaluateAsAssignment(EvaluationContext context, SimpleName simpleName) throws Exception {
        ExpressionValue value = ExecutionFlowUtils2.getValue(context.getFlowDescription(), (Expression)simpleName);
        if (value != null) {
            Expression expression = value.getExpression();
            if (expression.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY && expression.getParent().getLocationInParent() == FieldDeclaration.FRAGMENTS_PROPERTY) {
                return null;
            }
            if (expression.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)expression.getParent();
                MethodDeclaration methodDeclaration = AstNodeUtils.getEnclosingMethod((ASTNode)parameter);
                return context.evaluateUnknownParameter(methodDeclaration, parameter);
            }
            return AstEvaluationEngine.evaluate(context, expression);
        }
        throw new DesignerException(303, simpleName.getIdentifier());
    }
}

