/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public class DesignToolbarHelper {
    protected final ToolBarManager m_toolBarManager;
    private IEditPartViewer m_viewer;
    private ObjectInfo m_rootObject;
    private final ObjectEventListener m_objectRefreshListener = new ObjectEventListener(){

        public void refreshed() throws Exception {
            DesignerPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    DesignToolbarHelper.this.refreshDynamicActions(true, true);
                }
            });
        }
    };
    private static final String HIERARCHY_ACTIONS_GROUP = "HIERARCHY_ACTIONS_GROUP";
    private static final String HIERARCHY_ACTIONS_GROUP_END = "HIERARCHY_ACTIONS_GROUP_end";
    private final List<IContributionItem> m_hierarchyItems = Lists.newArrayList();
    private static final String SELECTION_ACTIONS_GROUP = "SELECTION_ACTIONS_GROUP";
    private static final String SELECTION_ACTIONS_GROUP_END = "SELECTION_ACTIONS_GROUP_end";
    private final List<IContributionItem> m_selectionItems = Lists.newArrayList();

    public DesignToolbarHelper(ToolBar toolBar) {
        this.m_toolBarManager = new ToolBarManager(toolBar);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DesignToolbarHelper.this.m_toolBarManager.dispose();
            }
        });
    }

    protected void initialize(IEditPartViewer viewer) {
        this.m_viewer = viewer;
    }

    public void fill() {
        IWorkbenchWindow window = DesignerPlugin.getActiveWorkbenchWindow();
        this.m_toolBarManager.add((IAction)ActionFactory.UNDO.create(window));
        this.m_toolBarManager.add((IAction)ActionFactory.REDO.create(window));
        this.m_toolBarManager.add((IContributionItem)new Separator());
        this.m_toolBarManager.add((IAction)ActionFactory.CUT.create(window));
        this.m_toolBarManager.add((IAction)ActionFactory.COPY.create(window));
        this.m_toolBarManager.add((IAction)ActionFactory.PASTE.create(window));
        this.m_toolBarManager.add((IAction)ActionFactory.DELETE.create(window));
        this.m_toolBarManager.add((IContributionItem)new Separator());
    }

    protected void fill2() {
        this.createHierarchyGroups();
        this.createSelectionGroups();
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DesignToolbarHelper.this.refreshDynamicActions(false, true);
            }
        });
        this.refreshDynamicActions(false, false);
    }

    public void setRoot(ObjectInfo rootObject) {
        if (this.m_rootObject != null) {
            this.m_rootObject.removeBroadcastListener(this.m_objectRefreshListener);
        }
        this.m_rootObject = rootObject;
        this.m_rootObject.addBroadcastListener(this.m_objectRefreshListener);
        this.refreshDynamicActions(true, true);
    }

    private void refreshDynamicActions(boolean refreshHierarchy, boolean refreshSelection) {
        Composite redrawControl = this.m_toolBarManager.getControl().getParent();
        redrawControl.setRedraw(false);
        try {
            if (refreshHierarchy) {
                this.refreshHierarchyActions();
            }
            if (refreshSelection) {
                this.refreshSelectionActions();
            }
            this.m_toolBarManager.update(true);
            redrawControl.layout();
        }
        finally {
            redrawControl.setRedraw(true);
        }
    }

    private void createHierarchyGroups() {
        this.m_toolBarManager.add((IContributionItem)new Separator(HIERARCHY_ACTIONS_GROUP));
        this.m_toolBarManager.add((IContributionItem)new Separator(HIERARCHY_ACTIONS_GROUP_END));
    }

    private void refreshHierarchyActions() {
        final List toRemove = Lists.newArrayList(this.m_hierarchyItems);
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                List items = Lists.newArrayList();
                DesignToolbarHelper.this.m_rootObject.getBroadcastObject().addHierarchyActions(items);
                DesignToolbarHelper.this.m_hierarchyItems.clear();
                toRemove.removeAll(items);
                for (Object object : items) {
                    IContributionItem item;
                    if (object instanceof IContributionItem) {
                        item = (IContributionItem)object;
                    } else {
                        IAction action = (IAction)object;
                        item = new ActionContributionItem(action);
                    }
                    DesignToolbarHelper.this.m_hierarchyItems.add(item);
                    DesignToolbarHelper.this.m_toolBarManager.remove(item);
                    DesignToolbarHelper.this.m_toolBarManager.appendToGroup(DesignToolbarHelper.HIERARCHY_ACTIONS_GROUP, item);
                }
            }
        });
        for (IContributionItem item : toRemove) {
            this.m_toolBarManager.remove(item);
            item.dispose();
        }
    }

    private void createSelectionGroups() {
        this.m_toolBarManager.add((IContributionItem)new Separator(SELECTION_ACTIONS_GROUP));
        this.m_toolBarManager.add((IContributionItem)new Separator(SELECTION_ACTIONS_GROUP_END));
    }

    private void refreshSelectionActions() {
        final List toRemove = Lists.newArrayList(this.m_selectionItems);
        final List selectedObjects = Lists.newArrayList();
        for (EditPart editPart : this.m_viewer.getSelectedEditParts()) {
            Object model = editPart.getModel();
            if (model instanceof ObjectInfo) {
                selectedObjects.add((ObjectInfo)model);
                continue;
            }
            return;
        }
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                List items = Lists.newArrayList();
                DesignToolbarHelper.this.m_rootObject.getBroadcastObject().addSelectionActions(selectedObjects, items);
                DesignToolbarHelper.this.m_selectionItems.clear();
                toRemove.removeAll(items);
                for (Object object : items) {
                    IContributionItem item;
                    if (object instanceof IContributionItem) {
                        item = (IContributionItem)object;
                    } else {
                        IAction action = (IAction)object;
                        item = new ActionContributionItem(action);
                    }
                    DesignToolbarHelper.this.m_selectionItems.add(item);
                    DesignToolbarHelper.this.m_toolBarManager.remove(item);
                    DesignToolbarHelper.this.m_toolBarManager.appendToGroup(DesignToolbarHelper.SELECTION_ACTIONS_GROUP, item);
                }
            }
        });
        for (IContributionItem item : toRemove) {
            this.m_toolBarManager.remove(item);
            item.dispose();
        }
    }
}

