/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class CommonTextSupport {
    private static final String KEY_TEXT_VIEWER = "textViewer";
    public IHandlerActivation contentAssistHandlerActivation;
    private final IHandlerService handlerService;
    private IHandlerActivation quickAssistHandlerActivation;
    private ISelectionChangedListener selectionChangedListener;
    private final UndoRedoListener undoRedoListener;

    private static boolean canDoGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            return textViewer.canDoOperation(3);
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            return textViewer.canDoOperation(4);
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            return textViewer.canDoOperation(5);
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return textViewer.canDoOperation(6);
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            return textViewer.canDoOperation(1);
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            return textViewer.canDoOperation(2);
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            return textViewer.canDoOperation(7);
        }
        return false;
    }

    public static boolean canPerformAction(String actionId, Control focusControl) {
        TextViewer viewer = CommonTextSupport.getTextViewer((Widget)focusControl);
        if (viewer != null) {
            return CommonTextSupport.canDoGlobalAction(actionId, viewer);
        }
        return !actionId.equals(ActionFactory.UNDO.getId()) && !actionId.equals(ActionFactory.REDO.getId());
    }

    private static boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    public static void doAction(String actionId, Control focusControl) {
        if (CommonTextSupport.canPerformDirectly(actionId, focusControl)) {
            return;
        }
        TextViewer viewer = CommonTextSupport.getTextViewer((Widget)focusControl);
        if (viewer != null) {
            CommonTextSupport.doGlobalAction(actionId, viewer);
        }
    }

    private static boolean doGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            textViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            textViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            textViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            textViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            textViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            textViewer.doOperation(2);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            textViewer.doOperation(7);
            return true;
        }
        return false;
    }

    public static TextViewer getTextViewer(Widget widget) {
        Object data;
        if (widget instanceof StyledText && (data = widget.getData(KEY_TEXT_VIEWER)) instanceof TextViewer) {
            return (TextViewer)data;
        }
        return null;
    }

    public static void setTextViewer(Widget widget, TextViewer textViewer) {
        widget.setData(KEY_TEXT_VIEWER, (Object)textViewer);
    }

    public CommonTextSupport(IHandlerService handlerService) {
        Assert.isNotNull((Object)handlerService);
        this.handlerService = handlerService;
        this.undoRedoListener = new UndoRedoListener();
    }

    private IHandlerActivation activateHandler(TextViewer viewer, int operation, String actionDefinitionId) {
        IHandler handler = this.createActionHandler((ITextOperationTarget)viewer, operation, actionDefinitionId);
        return this.handlerService.activateHandler(actionDefinitionId, handler, (Expression)new ActiveShellExpression(viewer.getTextWidget().getShell()));
    }

    private void activateHandlers(TextViewer viewer, boolean spellCheck) {
        this.deactivateHandlers();
        if (spellCheck) {
            this.quickAssistHandlerActivation = this.activateHandler(viewer, 22, "org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }
        this.contentAssistHandlerActivation = this.activateHandler(viewer, 13, "org.eclipse.ui.edit.text.contentAssist.proposals");
        this.undoRedoListener.setViewer(viewer);
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this.undoRedoListener);
    }

    public void configure(TextViewer viewer, Document document, boolean spellCheck) {
        if (spellCheck && viewer instanceof ISourceViewer) {
            this.configureAsEditor((ISourceViewer)viewer, document);
        } else {
            viewer.setDocument((IDocument)document);
        }
        this.install(viewer, spellCheck);
    }

    private void configureAsEditor(ISourceViewer viewer, Document document) {
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport(viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
            }
        });
        AnnotationModel annotationModel = new AnnotationModel();
        viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
    }

    private IHandler createActionHandler(final ITextOperationTarget viewer, final int operation, String actionDefinitionId) {
        Action action = new Action(){

            public void run() {
                if (viewer.canDoOperation(operation)) {
                    viewer.doOperation(operation);
                }
            }
        };
        action.setActionDefinitionId(actionDefinitionId);
        return new ActionHandler((IAction)action);
    }

    private void deactivateHandlers() {
        if (this.quickAssistHandlerActivation != null) {
            this.handlerService.deactivateHandler(this.quickAssistHandlerActivation);
            this.quickAssistHandlerActivation = null;
        }
        if (this.contentAssistHandlerActivation != null) {
            this.handlerService.deactivateHandler(this.contentAssistHandlerActivation);
            this.contentAssistHandlerActivation = null;
        }
        this.undoRedoListener.setViewer(null);
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this.undoRedoListener);
    }

    public void dispose() {
        this.deactivateHandlers();
    }

    public ISelectionChangedListener getSelectionChangedListener() {
        return this.selectionChangedListener;
    }

    public void install(TextViewer viewer, boolean spellCheck) {
        viewer.getControl().addFocusListener((FocusListener)new TextViewerFocusListener(viewer, spellCheck));
        if (this.selectionChangedListener != null) {
            viewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        CommonTextSupport.setTextViewer((Widget)viewer.getControl(), viewer);
    }

    public void setSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.selectionChangedListener = selectionChangedListener;
    }

    private class TextViewerFocusListener
    implements FocusListener {
        private final boolean spellCheck;
        private final TextViewer viewer;

        public TextViewerFocusListener(TextViewer viewer, boolean spellCheck) {
            this.viewer = viewer;
            this.spellCheck = spellCheck;
        }

        public void focusGained(FocusEvent e) {
            if (CommonTextSupport.this.selectionChangedListener != null) {
                CommonTextSupport.this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, this.viewer.getSelection()));
            }
            CommonTextSupport.this.activateHandlers(this.viewer, this.spellCheck);
        }

        public void focusLost(FocusEvent e) {
            CommonTextSupport.this.deactivateHandlers();
            if (CommonTextSupport.this.selectionChangedListener != null) {
                StyledText st = (StyledText)e.widget;
                st.setSelectionRange(st.getCaretOffset(), 0);
                CommonTextSupport.this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, (ISelection)StructuredSelection.EMPTY));
            }
        }
    }

    private class UndoRedoListener
    implements IOperationHistoryListener {
        private TextViewer viewer;

        private UndoRedoListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            if (this.viewer != null && CommonTextSupport.this.selectionChangedListener != null && Display.getCurrent() != null) {
                CommonTextSupport.this.selectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, this.viewer.getSelection()));
            }
        }

        public void setViewer(TextViewer viewer) {
            this.viewer = viewer;
        }
    }
}

