/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;

public abstract class AbstractIntCollection
implements IntCollection {
    public abstract IntIterator iterator();

    public abstract int size();

    protected AbstractIntCollection() {
    }

    public boolean add(int element) {
        throw new UnsupportedOperationException("add(int) is not supported.");
    }

    public boolean addAll(IntCollection c) {
        boolean modified = false;
        IntIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    public void clear() {
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public boolean contains(int element) {
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(IntCollection c) {
        IntIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    public boolean removeElement(int element) {
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(IntCollection c) {
        boolean modified = false;
        IntIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    public boolean retainAll(IntCollection c) {
        boolean modified = false;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        int i = 0;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    public int[] toArray(int[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

