/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateMavenProjectsOperation
implements IRunnableWithProgress {
    private final List<IWorkingSet> workingSets;

    public AbstractCreateMavenProjectsOperation(List<IWorkingSet> workingSets) {
        this.workingSets = workingSets;
    }

    protected abstract List<IProject> doCreateMavenProjects(IProgressMonitor var1) throws CoreException;

    public static void addToWorkingSets(IProject project, List<IWorkingSet> workingSets) {
        if (workingSets != null && workingSets.size() > 0) {
            for (IWorkingSet workingSet : workingSets) {
                if (workingSet == null) continue;
                IAdaptable[] oldElements = workingSet.getElements();
                IAdaptable[] newElements = new IAdaptable[oldElements.length + 1];
                System.arraycopy(oldElements, 0, newElements, 0, oldElements.length);
                newElements[oldElements.length] = project;
                workingSet.setElements(newElements);
            }
        }
    }

    protected static ArrayList<IProject> toProjects(List<IMavenProjectImportResult> results) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (IMavenProjectImportResult result : results) {
            if (result.getProject() == null) continue;
            projects.add(result.getProject());
        }
        return projects;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        Job.getJobManager().beginRule((ISchedulingRule)rule, monitor);
        try {
            try {
                List<IProject> projects = this.doCreateMavenProjects(monitor);
                if (projects != null) {
                    for (IProject project : projects) {
                        AbstractCreateMavenProjectsOperation.addToWorkingSets(project, this.workingSets);
                    }
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
    }

    public static IStatus toStatus(InvocationTargetException e) {
        Throwable t = e.getCause();
        if (t instanceof CoreException) {
            return ((CoreException)t).getStatus();
        }
        return new Status(4, "org.eclipse.m2e.core.ui", t.getMessage(), t);
    }
}

