/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSettingsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(MavenSettingsPreferencePage.class);
    final MavenRuntimeManager runtimeManager;
    final IMavenConfiguration mavenConfiguration;
    final IMaven maven;
    MavenRuntime defaultRuntime;
    Text userSettingsText;
    Text localRepositoryText;
    boolean dirty = false;
    private Link userSettingsLink;

    public MavenSettingsPreferencePage() {
        this.setTitle(Messages.MavenSettingsPreferencePage_title);
        this.runtimeManager = MavenPlugin.getMavenRuntimeManager();
        this.mavenConfiguration = MavenPlugin.getMavenConfiguration();
        this.maven = MavenPlugin.getMaven();
    }

    public void init(IWorkbench workbench) {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateLocalRepository();
        }
    }

    protected void performDefaults() {
        this.userSettingsText.setText(MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath());
        this.setDirty(true);
        this.updateLocalRepository();
        super.performDefaults();
    }

    protected void updateSettings(final boolean updateMavenDependencies) {
        final String userSettings = this.getUserSettings();
        new Job(Messages.MavenSettingsPreferencePage_job_updating){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    File localRepositoryDir = new File(MavenSettingsPreferencePage.this.maven.getLocalRepository().getBasedir());
                    if (userSettings.length() > 0) {
                        MavenSettingsPreferencePage.this.mavenConfiguration.setUserSettingsFile(userSettings);
                    } else {
                        MavenSettingsPreferencePage.this.mavenConfiguration.setUserSettingsFile(null);
                    }
                    File newRepositoryDir = new File(MavenSettingsPreferencePage.this.maven.getLocalRepository().getBasedir());
                    if (!newRepositoryDir.equals(localRepositoryDir)) {
                        IndexManager indexManager = MavenPlugin.getIndexManager();
                        indexManager.getWorkspaceIndex().updateIndex(true, monitor);
                    }
                    if (updateMavenDependencies) {
                        IMavenProjectFacade[] projects = MavenPlugin.getMavenProjectRegistry().getProjects();
                        ArrayList<IProject> allProjects = new ArrayList<IProject>();
                        if (projects != null) {
                            MavenPlugin.getMaven().reloadSettings();
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, projects.length);
                            int i = 0;
                            while (i < projects.length) {
                                subMonitor.beginTask(NLS.bind((String)Messages.MavenSettingsPreferencePage_task_updating, (Object)projects[i].getProject().getName()), 1);
                                allProjects.add(projects[i].getProject());
                                ++i;
                            }
                            MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(allProjects.toArray(new IProject[0]), MavenSettingsPreferencePage.this.mavenConfiguration.isOffline(), true));
                            subMonitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return e.getStatus();
                }
            }
        }.schedule();
    }

    protected void performApply() {
        if (this.dirty) {
            this.updateSettings(false);
        }
    }

    public boolean performOk() {
        if (this.dirty) {
            this.updateSettings(false);
        }
        return true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.createUserSettings(composite);
        Label localRepositoryLabel = new Label(composite, 0);
        GridData gd = new GridData(4, 0x1000000, true, false, 4, 1);
        gd.verticalIndent = 25;
        localRepositoryLabel.setLayoutData((Object)gd);
        localRepositoryLabel.setText(Messages.MavenSettingsPreferencePage_lblLocal);
        this.localRepositoryText = new Text(composite, 2056);
        this.localRepositoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.localRepositoryText.setData("name", (Object)"localRepositoryText");
        this.localRepositoryText.setEditable(false);
        Button reindexButton = new Button(composite, 0);
        reindexButton.setLayoutData((Object)new GridData(4, 131072, false, false, 1, 1));
        reindexButton.setText(Messages.preferencesReindexButton);
        reindexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new WorkspaceJob(Messages.MavenSettingsPreferencePage_job_indexing){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        IndexManager indexManager = MavenPlugin.getIndexManager();
                        indexManager.getWorkspaceIndex().updateIndex(true, monitor);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        this.defaultRuntime = this.runtimeManager.getDefaultRuntime();
        String userSettings = this.mavenConfiguration.getUserSettingsFile();
        if (userSettings == null || userSettings.length() == 0) {
            this.userSettingsText.setText(MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath());
        } else {
            this.userSettingsText.setText(userSettings);
        }
        this.checkSettings();
        this.updateLocalRepository();
        this.userSettingsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyevent) {
                MavenSettingsPreferencePage.this.updateLocalRepository();
                MavenSettingsPreferencePage.this.checkSettings();
                MavenSettingsPreferencePage.this.setDirty(true);
            }
        });
        return composite;
    }

    public void updateSettingsLink(boolean active) {
        String text = Messages.MavenSettingsPreferencePage_link1;
        if (active) {
            text = Messages.MavenSettingsPreferencePage_link2;
        }
        this.userSettingsLink.setText(text);
    }

    private void createUserSettings(Composite composite) {
        this.userSettingsLink = new Link(composite, 0);
        this.userSettingsLink.setData("name", (Object)"userSettingsLink");
        this.userSettingsLink.setText(Messages.MavenSettingsPreferencePage_link2);
        this.userSettingsLink.setToolTipText(Messages.MavenSettingsPreferencePage_link_tooltip);
        GridData gd_userSettingsLabel = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_userSettingsLabel.verticalIndent = 15;
        this.userSettingsLink.setLayoutData((Object)gd_userSettingsLabel);
        this.userSettingsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String userSettings = MavenSettingsPreferencePage.this.getUserSettings();
                if (userSettings.length() == 0) {
                    userSettings = MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
                }
                MavenSettingsPreferencePage.this.openEditor(userSettings);
            }
        });
        this.userSettingsText = new Text(composite, 2048);
        this.userSettingsText.setData("name", (Object)"userSettingsText");
        GridData gd_userSettingsText = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_userSettingsText.verticalIndent = 5;
        gd_userSettingsText.widthHint = 100;
        this.userSettingsText.setLayoutData((Object)gd_userSettingsText);
        Button userSettingsBrowseButton = new Button(composite, 0);
        GridData gd_userSettingsBrowseButton = new GridData(4, 131072, false, false, 1, 1);
        userSettingsBrowseButton.setLayoutData((Object)gd_userSettingsBrowseButton);
        userSettingsBrowseButton.setText(Messages.MavenSettingsPreferencePage_btnBrowse);
        userSettingsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file;
                FileDialog dialog = new FileDialog(MavenSettingsPreferencePage.this.getShell(), 4096);
                if (MavenSettingsPreferencePage.this.getUserSettings().length() > 0) {
                    dialog.setFileName(MavenSettingsPreferencePage.this.getUserSettings());
                }
                if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
                    MavenSettingsPreferencePage.this.userSettingsText.setText(file);
                    MavenSettingsPreferencePage.this.updateLocalRepository();
                    MavenSettingsPreferencePage.this.checkSettings();
                }
            }
        });
        Button updateSettings = new Button(composite, 0);
        updateSettings.setText(Messages.MavenSettingsPreferencePage_btnUpdate);
        updateSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenSettingsPreferencePage.this.updateSettings(true);
            }
        });
    }

    protected void updateLocalRepository() {
        String userSettings = this.getUserSettings();
        String globalSettings = this.runtimeManager.getGlobalSettingsFile();
        try {
            Settings settings = this.maven.buildSettings(globalSettings, userSettings);
            String localRepository = settings.getLocalRepository();
            if (localRepository == null) {
                localRepository = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
            }
            if (!this.localRepositoryText.isDisposed()) {
                this.localRepositoryText.setText(localRepository == null ? "" : localRepository);
            }
        }
        catch (CoreException e) {
            this.setMessage(e.getMessage(), 3);
        }
    }

    protected void checkSettings() {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean fileExists = false;
        String userSettings = this.getUserSettings();
        if (userSettings != null && userSettings.length() > 0) {
            File userSettingsFile = new File(userSettings);
            if (!userSettingsFile.exists()) {
                this.setMessage(Messages.MavenSettingsPreferencePage_error_missing, 2);
                userSettings = null;
            } else {
                fileExists = true;
            }
        } else {
            userSettings = null;
        }
        this.updateSettingsLink(fileExists);
        List result = this.maven.validateSettings(userSettings);
        if (result.size() > 0) {
            this.setMessage(NLS.bind((String)Messages.MavenSettingsPreferencePage_error_parse, (Object)((SettingsProblem)result.get(0)).getMessage()), 2);
        }
    }

    void openEditor(final String fileName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("settings.xml");
        File file = new File(fileName);
        IEditorInput input = null;
        try {
            Class<?> javaInput = null;
            try {
                javaInput = Class.forName("org.eclipse.ui.internal.editors.text.JavaFileEditorInput");
                Constructor<?> cons = javaInput.getConstructor(File.class);
                input = (IEditorInput)cons.newInstance(file);
            }
            catch (Exception exception) {
                try {
                    IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
                    Class<?> storeInput = Class.forName("org.eclipse.ui.ide.FileStoreEditorInput");
                    Constructor<?> cons = storeInput.getConstructor(IFileStore.class);
                    input = (IEditorInput)cons.newInstance(fileStore);
                }
                catch (Exception exception2) {}
            }
            final IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, input, (String)desc.getId());
            editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (!editor.isDirty()) {
                        log.info("Refreshing settings " + fileName);
                    }
                }
            });
        }
        catch (PartInitException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    String getUserSettings() {
        return this.userSettingsText.getText().trim();
    }
}

