/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class MavenProjectLifecycleMappingPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        TableViewer tableViewer = new TableViewer(composite, 2048);
        tableViewer.setUseHashlookup(true);
        Table table = tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn treeViewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn columnMaven = treeViewerColumn.getColumn();
        columnMaven.setWidth(100);
        columnMaven.setText("Maven");
        TableViewerColumn treeViewerColumn_1 = new TableViewerColumn(tableViewer, 0);
        TableColumn columnEclipseMapping = treeViewerColumn_1.getColumn();
        columnEclipseMapping.setWidth(100);
        columnEclipseMapping.setText("Eclipse Mapping");
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IMavenProjectFacade) {
                    return MavenProjectLifecycleMappingPage.this.getMojoExecutions((IMavenProjectFacade)inputElement);
                }
                return null;
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof MojoExecutionInfo) {
                    MojoExecutionInfo executionInfo = (MojoExecutionInfo)element;
                    if (columnIndex == 0) {
                        MojoExecutionKey executionKey = executionInfo.getMojoExecution();
                        return String.valueOf(executionKey.getArtifactId()) + ":" + executionKey.getGoal();
                    }
                    if (columnIndex == 1) {
                        StringBuilder sb = new StringBuilder();
                        PluginExecutionMetadata mapping = executionInfo.getMapping();
                        sb.append(mapping.getAction().toString());
                        if (mapping.getAction() == PluginExecutionAction.configurator) {
                            sb.append(" ").append(LifecycleMappingFactory.getProjectConfiguratorId((IPluginExecutionMetadata)mapping));
                        } else if (mapping.getAction() == PluginExecutionAction.error) {
                            sb.append(" ").append(LifecycleMappingFactory.getActionMessage((IPluginExecutionMetadata)mapping));
                        }
                        return sb.toString();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        tableViewer.setInput((Object)this.getMavenProjectFacade());
        return composite;
    }

    protected Object[] getMojoExecutions(IMavenProjectFacade project) {
        ArrayList<MojoExecutionInfo> executions = new ArrayList<MojoExecutionInfo>();
        for (Map.Entry entry : project.getMojoExecutionMapping().entrySet()) {
            MojoExecutionKey executionKey = (MojoExecutionKey)entry.getKey();
            for (IPluginExecutionMetadata mapping : (List)entry.getValue()) {
                MojoExecutionInfo executionInfo = new MojoExecutionInfo(executionKey, (PluginExecutionMetadata)mapping);
                executions.add(executionInfo);
            }
        }
        return executions.toArray();
    }

    private IMavenProjectFacade getMavenProjectFacade() {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        return MavenPlugin.getMavenProjectRegistry().getProject(project);
    }

    private static class MojoExecutionInfo {
        private final MojoExecutionKey mojoExecution;
        private final PluginExecutionMetadata mapping;

        public MojoExecutionInfo(MojoExecutionKey mojoExecution, PluginExecutionMetadata mapping) {
            this.mojoExecution = mojoExecution;
            this.mapping = mapping;
        }

        public MojoExecutionKey getMojoExecution() {
            return this.mojoExecution;
        }

        public PluginExecutionMetadata getMapping() {
            return this.mapping;
        }
    }
}

