/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.markers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.UpdateConfigurationJob;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerResolutionGenerator.class);
    static QualifiedName QUALIFIED = new QualifiedName("org.eclipse.m2e.core.ui", "refreshResolution");

    public boolean hasResolutions(IMarker marker) {
        return true;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            IMarkerResolution[] cached = (IMarkerResolution[])marker.getResource().getSessionProperty(QUALIFIED);
            if (cached == null) {
                cached = new IMarkerResolution[]{new RefreshResolution()};
                marker.getResource().setSessionProperty(QUALIFIED, (Object)cached);
            }
            return cached;
        }
        catch (CoreException coreException) {
            return new IMarkerResolution[]{new RefreshResolution()};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshResolution
    extends WorkbenchMarkerResolution {
        private RefreshResolution() {
        }

        public String getDescription() {
            return Messages.MarkerResolutionGenerator_desc;
        }

        public Image getImage() {
            return null;
        }

        public String getLabel() {
            return Messages.MarkerResolutionGenerator_label;
        }

        public void run(IMarker marker) {
            Set<IProject> projects = this.getProjects(marker);
            new UpdateConfigurationJob(projects.toArray(new IProject[projects.size()])).schedule();
        }

        public void run(IMarker[] markers, IProgressMonitor monitor) {
            Set<IProject> projects = this.getProjects(markers);
            new UpdateConfigurationJob(projects.toArray(new IProject[projects.size()])).schedule();
        }

        private Set<IProject> getProjects(IMarker ... markers) {
            HashSet<IProject> toRet = new HashSet<IProject>();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker mark = iMarkerArray[n2];
                IResource res = mark.getResource();
                IProject prj = res.getProject();
                if (prj != null) {
                    toRet.add(prj);
                }
                ++n2;
            }
            return toRet;
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            ArrayList<IMarker> toRet = new ArrayList<IMarker>();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                try {
                    if ("org.eclipse.m2e.core.maven2Problem.configuration".equals(m.getType())) {
                        toRet.add(m);
                    }
                }
                catch (CoreException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
                ++n2;
            }
            return toRet.toArray(new IMarker[0]);
        }
    }
}

