/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.console;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.MavenConsoleRemoveAction;
import org.eclipse.m2e.core.ui.internal.actions.MavenDebugOutputAction;
import org.eclipse.m2e.core.ui.internal.console.MavenShowConsoleAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class MavenConsolePageParticipant
implements IConsolePageParticipant {
    private IAction consoleRemoveAction;
    private IAction debugAction;
    private IAction showOnErrorAction;
    private IAction showOnOutputAction;
    private static final String SHOW_ON_OUTPUT_LBL = Messages.MavenConsolePageParticipant_any;
    private static final String SHOW_ON_ERR_LBL = Messages.MavenConsolePageParticipant_error;

    public void init(IPageBookViewPage page, IConsole console) {
        this.consoleRemoveAction = new MavenConsoleRemoveAction();
        this.debugAction = new MavenDebugOutputAction();
        this.showOnOutputAction = new ShowOnOutputAction(console, SHOW_ON_OUTPUT_LBL);
        this.showOnErrorAction = new ShowOnErrorAction(console, SHOW_ON_ERR_LBL);
        IActionBars actionBars = page.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
    }

    private void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("launchGroup", this.consoleRemoveAction);
        mgr.prependToGroup("outputGroup", this.debugAction);
        mgr.appendToGroup("outputGroup", this.showOnOutputAction);
        mgr.appendToGroup("outputGroup", this.showOnErrorAction);
    }

    public void dispose() {
        this.consoleRemoveAction = null;
        this.debugAction = null;
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    class ShowOnErrorAction
    extends MavenShowConsoleAction {
        public ShowOnErrorAction(IConsole console, String name) {
            super(name);
            this.setImageDescriptor(MavenImages.SHOW_CONSOLE_ERR);
        }

        protected String getKey() {
            return "eclipse.m2.showConsoleOnErr";
        }
    }

    class ShowOnOutputAction
    extends MavenShowConsoleAction {
        public ShowOnOutputAction(IConsole console, String name) {
            super(name);
            this.setImageDescriptor(MavenImages.SHOW_CONSOLE_OUT);
        }

        protected String getKey() {
            return "eclipse.m2.showConsoleOnOutput";
        }
    }
}

