/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Logs {
    private static final String ANCHOR = "{}";
    private static final boolean SLF4J_ENABLED;
    private static final boolean DEBUG_ENABLED;

    private Logs() {
    }

    public static void debug(Class<?> clazz, String format, Object arg1, Object arg2) {
        if (DEBUG_ENABLED) {
            if (SLF4J_ENABLED) {
                LoggerFactory.getLogger(clazz).debug(format, arg1, arg2);
            } else {
                String at = clazz.getName();
                Logger.getLogger(at).logp(Level.FINE, at, null, Logs.format(Logs.format(format, arg1), arg2));
            }
        }
    }

    public static void warn(Class<?> clazz, String message, Throwable cause) {
        if (SLF4J_ENABLED) {
            LoggerFactory.getLogger(clazz).warn(message, cause);
        } else {
            String at = clazz.getName();
            Logger.getLogger(at).logp(Level.WARNING, at, null, message, cause);
        }
    }

    private static String format(String format, Object arg) {
        int cursor = format.indexOf(ANCHOR);
        if (cursor < 0) {
            return format;
        }
        StringBuilder buf = new StringBuilder();
        if (cursor > 0) {
            buf.append(format.substring(0, cursor));
        }
        buf.append(arg);
        if ((cursor += ANCHOR.length()) < format.length()) {
            buf.append(format.substring(cursor, format.length()));
        }
        return buf.toString();
    }

    static {
        boolean slf4jEnabled = true;
        boolean debugEnabled = false;
        try {
            debugEnabled = LoggerFactory.getLogger(Logs.class).isDebugEnabled();
        }
        catch (Throwable e) {
            slf4jEnabled = false;
            debugEnabled = Logger.getLogger(Logs.class.getName()).isLoggable(Level.FINE);
        }
        SLF4J_ENABLED = slf4jEnabled;
        DEBUG_ENABLED = debugEnabled;
        new Logs();
    }
}

